/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.service.directory.impl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.service.directory.Address;
import org.drools.grid.service.directory.impl.AddressImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridServiceDescriptionImpl
implements GridServiceDescription,
Serializable {
    private String id;
    private Class serviceInterface;
    private Map<String, Address> addresses = new HashMap<String, Address>();
    private Serializable data;

    public GridServiceDescriptionImpl() {
    }

    public GridServiceDescriptionImpl(Class cls) {
        this.serviceInterface = cls;
        this.id = cls.getName();
    }

    public GridServiceDescriptionImpl(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    @Override
    public synchronized Address addAddress(String protocol) {
        AddressImpl address = new AddressImpl(this, protocol, null);
        this.addresses.put(address.getTransport(), address);
        return address;
    }

    @Override
    public synchronized Map<String, Address> getAddresses() {
        return Collections.unmodifiableMap(this.addresses);
    }

    @Override
    public synchronized void removeAddress(String transport) {
        this.addresses.remove(transport);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addresses == null ? 0 : ((Object)this.addresses).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        GridServiceDescription other = (GridServiceDescription)obj;
        return this.getId().equals(other.getId());
    }

    public String toString() {
        String result = this.id + "@";
        Set<String> keys = this.addresses.keySet();
        for (String key : keys) {
            if (!(this.addresses.get(key).getObject() instanceof InetSocketAddress[])) continue;
            result = result + key + "=[" + ((InetSocketAddress[])this.addresses.get(key).getObject())[0].getHostName() + ":" + ((InetSocketAddress[])this.addresses.get(key).getObject())[0].getPort() + "]/" + this.addresses.get(key).getTransport();
        }
        return result;
    }

    @Override
    public Serializable getData() {
        return this.data;
    }

    @Override
    public void setData(Serializable data) {
        this.data = data;
    }
}

