/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.command.impl.ContextImplWithEviction;
import org.drools.time.Job;
import org.drools.time.JobContext;

public class EvictionJob
implements Job {
    private static Logger log = Logger.getLogger(EvictionJob.class.getName());
    private ContextImplWithEviction contextImpl;

    public EvictionJob(ContextImplWithEviction contextImpl) {
        this.contextImpl = contextImpl;
    }

    public void execute(JobContext ctx) {
        Map evictionMap = this.contextImpl.getEvictionMap();
        for (String key : evictionMap.keySet()) {
            Long lastTimeAccessed = (Long)evictionMap.get(key);
            long validTime = lastTimeAccessed + this.contextImpl.getEntryEvictionTime();
            long evicted = validTime - System.currentTimeMillis();
            if (evicted >= 0L) continue;
            log.log(Level.FINE, "Removing _TEMP_ key =" + key + " Based on evictions policies / Evicted Time=" + evicted);
            evictionMap.remove(key);
            this.contextImpl.remove(key);
        }
    }
}

