/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.invaders;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.games.GameUI;
import org.drools.games.invaders.InvadersConfiguration;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invaders4Main {
    private static final Logger LOG = LoggerFactory.getLogger(Invaders4Main.class);

    public static void main(String[] args) {
        new Invaders4Main().init(true);
    }

    public void init(boolean exitOnClose) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        KieSession ksession = kc.newKieSession("Invaders4KS");
        InvadersConfiguration conf = new InvadersConfiguration();
        conf.setExitOnClose(exitOnClose);
        GameUI ui = new GameUI(ksession, conf);
        ui.init();
        ksession.setGlobal("conf", (Object)conf);
        ksession.setGlobal("ui", (Object)ui);
        this.runKSession(ksession);
    }

    public void runKSession(final KieSession ksession) {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ksession.fireUntilHalt();
                }
                catch (Exception e) {
                    LOG.error("Exception", (Throwable)e);
                }
            }
        });
    }
}

