/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.traits;

import java.util.Collection;
import org.drools.traits.core.base.evaluators.IsAEvaluatorDefinition;
import org.drools.util.io.ClassPathResource;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class TraitExample {
    private static KieSession getSession(String drl) {
        KieHelper kieHelper = new KieHelper();
        kieHelper.kfs.write((Resource)new ClassPathResource("org/drools/examples/traits/" + drl));
        return kieHelper.build(new KieBaseOption[0]).newKieSession();
    }

    public static void run(String demo) {
        System.setProperty("drools.evaluator.isA", IsAEvaluatorDefinition.class.getName());
        KieSession kSession = TraitExample.getSession(demo);
        kSession.fireAllRules();
        Collection c = kSession.getObjects();
        System.out.println("------------------------- " + c.size() + " ----------------------");
        for (Object o : c) {
            System.out.println(" \t --- " + o);
        }
        System.out.println("-----------------------------------------------------------------");
        kSession.dispose();
    }

    public static void main(String[] args) {
        TraitExample.run("noTraits.drl");
        TraitExample.run("traitsDon.drl");
        TraitExample.run("multipleTraits.drl");
        TraitExample.run("traitsMixins.drl");
        TraitExample.run("traitsShed.drl");
    }
}

