/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.state;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class State {
    public static final int NOTRUN = 0;
    public static final int FINISHED = 1;
    private final PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private String name;
    private int state;

    public State() {
    }

    public State(String name) {
        this.name = name;
        this.state = 0;
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        int oldState = this.state;
        this.state = newState;
        this.changes.firePropertyChange("state", oldState, newState);
    }

    public boolean inState(String name, int state) {
        return this.name.equals(name) && this.state == state;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return this.name + "[NOTRUN]";
            }
        }
        return this.name + "[FINISHED]";
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }
}

