/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.workitemconsequence;

import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class WorkItemConsequenceExample1 {
    public static void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"WorkItemConsequence1.drl", WorkItemConsequenceExample1.class), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Compilation error.\n" + kbuilder.getErrors().toString());
        }
        KieSession ksession = kbase.newKieSession();
        ksession.getWorkItemManager().registerWorkItemHandler("EmailWorkItemHandler", (WorkItemHandler)new EmailWorkItemHandler());
        PersonLocation brains = new PersonLocation("Brains", 5L);
        ksession.insert((Object)brains);
        ksession.fireAllRules();
        PersonLocation gargamel = new PersonLocation("Gargamel", 10L);
        FactHandle gargamelFactHandle = ksession.insert((Object)gargamel);
        ksession.fireAllRules();
        gargamel.setDistance(5L);
        ksession.update(gargamelFactHandle, (Object)gargamel);
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static class EmailWorkItemHandler
    implements WorkItemHandler {
        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            String emailAddress = (String)workItem.getParameter("emailAddress");
            String message = (String)workItem.getParameter("message");
            System.out.println("to: " + emailAddress + " --> " + message);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    public static class Email {
        private String emailAddress;
        private String message;

        public Email(String emailAddress, String message) {
            this.emailAddress = emailAddress;
            this.message = message;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class PersonLocation {
        private String name;
        private long distance;

        public PersonLocation(String name, long distance) {
            this.name = name;
            this.distance = distance;
        }

        public String getName() {
            return this.name;
        }

        public void setDistance(long distance) {
            this.distance = distance;
        }

        public long getDistance() {
            return this.distance;
        }
    }
}

