/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.adventures;

import java.awt.EventQueue;
import java.util.Map;
import org.drools.games.adventures.AdventureFrame;
import org.drools.games.adventures.GameEngine;
import org.drools.games.adventures.UserSession;
import org.drools.games.adventures.model.Character;
import org.drools.games.adventures.model.LookCommand;

public class TextAdventure {
    public static void main(String[] args) {
        new TextAdventure().init(true);
    }

    public void init(final boolean exitOnClose) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameEngine engine = new GameEngine();
                engine.createGame();
                TextAdventure.createFrame(engine, exitOnClose ? 3 : 2);
            }
        });
    }

    public static void createFrame(GameEngine engine, int onClose) {
        UserSession session = new UserSession();
        Map characterMap = engine.getData().get("characters");
        session.setCharacter((Character)characterMap.get("hero"));
        AdventureFrame frame = new AdventureFrame(session, engine, onClose);
        frame.setVisible(true);
        session.getChannels().put("output", new AdventureFrame.JTextAreaChannel(frame.getOutputTextArea()));
        session.getChannels().put("events", new AdventureFrame.JTextAreaChannel(frame.getLocalEventsTextArea()));
        session.getChannels().put("exits", new AdventureFrame.JTableChannel(frame.getExitsTable()));
        session.getChannels().put("things", new AdventureFrame.JTableChannel(frame.getThingsTable()));
        session.getChannels().put("inventory", new AdventureFrame.JTableChannel(frame.getInventoryTable()));
        engine.ksession.insert((Object)session);
        LookCommand lc = new LookCommand((Character)characterMap.get("hero"));
        lc.setSession(session);
        engine.getKieSession().insert((Object)lc);
        engine.ksession.fireAllRules();
    }
}

