/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.adventures;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.games.adventures.Counter;
import org.drools.games.adventures.UserSession;
import org.drools.games.adventures.model.Command;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.mvel2.MVEL;

public class GameEngine {
    KieSession ksession;
    Map<String, Map> data;

    public void createGame() {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        this.ksession = kc.newKieSession("TextAdventureKS");
        Counter c = new Counter();
        this.ksession.setGlobal("counter", (Object)c);
        HashMap<String, Counter> vars = new HashMap<String, Counter>();
        vars.put("c", c);
        try {
            String mvelContent = new String(IOUtils.toByteArray((InputStream)this.getClass().getResource("data.mvel").openStream()));
            this.data = (Map)MVEL.executeExpression((Object)MVEL.compileExpression((String)mvelContent), vars);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Object o : this.data.get("rooms").values()) {
            this.ksession.insert(o);
        }
        for (Object o : this.data.get("doors").values()) {
            this.ksession.insert(o);
        }
        for (Object o : this.data.get("characters").values()) {
            this.ksession.insert(o);
        }
        for (Object o : this.data.get("items").values()) {
            this.ksession.insert(o);
        }
        for (Object o : this.data.get("locations").values()) {
            this.ksession.insert(o);
        }
    }

    public Map<String, Map> getData() {
        return this.data;
    }

    public void receiveMessage(UserSession session, List cmdList) {
        try {
            Class cls = (Class)cmdList.get(0);
            Class[] constructorParamTypes = new Class[cmdList.size() - 1];
            for (int i = 1; i < cmdList.size(); ++i) {
                constructorParamTypes[i - 1] = cmdList.get(i).getClass();
            }
            Object[] args = cmdList.subList(1, cmdList.size()).toArray();
            Command cmd = (Command)cls.getDeclaredConstructors()[0].newInstance(args);
            cmd.setSession(session);
            this.ksession.insert((Object)cmd);
            this.ksession.fireAllRules();
        }
        catch (Exception e) {
            e.printStackTrace();
            session.getChannels().get("output").send((Object)("Unable to Execute Command: " + cmdList));
        }
    }

    public KieSession getKieSession() {
        return this.ksession;
    }
}

