/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku;

import java.util.HashSet;
import java.util.Set;
import org.drools.examples.sudoku.CellCol;
import org.drools.examples.sudoku.CellRow;
import org.drools.examples.sudoku.CellSqr;
import org.drools.examples.sudoku.SetOfNine;

public class Cell
extends SetOfNine {
    private Integer value;
    private CellRow cellRow;
    private CellCol cellCol;
    private CellSqr cellSqr;
    private Set<Cell> exCells;

    public void makeReferences(CellRow row, CellCol col, CellSqr sqr) {
        this.cellRow = row;
        this.cellCol = col;
        this.cellSqr = sqr;
        this.exCells = new HashSet<Cell>();
        this.exCells.addAll(this.cellRow.getCells());
        this.exCells.addAll(this.cellCol.getCells());
        this.exCells.addAll(this.cellSqr.getCells());
        this.exCells.remove(this);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.blockExcept(new Integer[0]);
        this.value = value;
    }

    public Set<Cell> getExCells() {
        return this.exCells;
    }

    public CellRow getCellRow() {
        return this.cellRow;
    }

    public int getRowNo() {
        return this.cellRow.getNumber();
    }

    public CellCol getCellCol() {
        return this.cellCol;
    }

    public int getColNo() {
        return this.cellCol.getNumber();
    }

    public CellSqr getCellSqr() {
        return this.cellSqr;
    }

    public String toString() {
        return this.posAsString() + ": " + this.valueAsString();
    }

    public String valueAsString() {
        return this.value == null ? " " : this.value.toString();
    }

    public String posAsString() {
        return "[" + this.cellRow.getNumber() + "," + this.cellCol.getNumber() + "]";
    }
}

