/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.wumpus.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.drools.games.wumpus.ClimbCommand;
import org.drools.games.wumpus.GrabCommand;
import org.drools.games.wumpus.Move;
import org.drools.games.wumpus.MoveCommand;
import org.drools.games.wumpus.Reset;
import org.drools.games.wumpus.Score;
import org.drools.games.wumpus.ShootCommand;
import org.drools.games.wumpus.WumpusWorldConfiguration;
import org.drools.games.wumpus.view.GameView;
import org.drools.runtime.Channel;
import org.drools.runtime.rule.FactHandle;

public class GameUI {
    private final WumpusWorldConfiguration wumpusWorldConfiguration;
    private JFrame frame;
    private GameView gameView;
    private CavePanel cavePanel;
    private SensorPanel sensorPanel;

    public GameUI(WumpusWorldConfiguration wumpusWorldConfiguration) {
        this.wumpusWorldConfiguration = wumpusWorldConfiguration;
    }

    public GameUI(WumpusWorldConfiguration wumpusWorldConfiguration, GameView gameView) {
        this(wumpusWorldConfiguration);
        this.gameView = gameView;
        if (this.gameView == null) {
            this.gameView = new GameView();
            this.gameView.init(50, 50, 3, 20, 5, 5);
        }
        this.initialize();
    }

    public void setGameView(GameView gameView) {
        this.gameView = gameView;
        if (this.frame == null) {
            this.initialize();
        }
    }

    public JFrame getParentJFrame() {
        return this.frame;
    }

    public GameView getGameView() {
        return this.gameView;
    }

    public CavePanel getCavePanel() {
        return this.cavePanel;
    }

    public SensorPanel getSensorPanel() {
        return this.sensorPanel;
    }

    private void initialize() {
        this.frame = new JFrame("Wumpus World");
        this.frame.getContentPane().setBackground(Color.WHITE);
        this.frame.setDefaultCloseOperation(this.wumpusWorldConfiguration.isExitOnClose() ? 3 : 2);
        this.frame.setSize(926, 603);
        this.frame.getContentPane().setLayout((LayoutManager)new MigLayout("", "[540px:n][grow,fill]", "[30px,top][300px,top][100px,top][grow]"));
        JPanel scorePanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)scorePanel.getLayout();
        flowLayout.setAlignment(0);
        scorePanel.setBackground(Color.WHITE);
        this.frame.getContentPane().add((Component)scorePanel, "cell 0 0,grow");
        JLabel lblScore = new JLabel("Score");
        scorePanel.add(lblScore);
        final JTextField txtScore = new JTextField();
        this.gameView.getKsession().getChannels().put("score", new Channel(){

            public void send(Object object) {
                txtScore.setText("" + ((Score)object).getValue());
            }
        });
        txtScore.setEditable(false);
        scorePanel.add(txtScore);
        txtScore.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        this.frame.getContentPane().add((Component)scrollPane, "cell 1 0 1 4,grow");
        JPanel actionPanel = new JPanel();
        actionPanel.setBackground(Color.WHITE);
        this.frame.getContentPane().add((Component)actionPanel, "cell 0 1,grow");
        actionPanel.setLayout((LayoutManager)new MigLayout("", "[200px,left][320px:n]", "[grow]"));
        JPanel controls = new JPanel();
        controls.setBackground(Color.WHITE);
        controls.setLayout((LayoutManager)new MigLayout("", "[grow,fill]", "[::100px,top][200px,top]"));
        controls.add((Component)this.drawActionPanel(), "cell 0 0,alignx left,aligny top");
        controls.add((Component)this.drawMovePanel(), "cell 0 1,alignx left,growy");
        actionPanel.add((Component)controls, "cell 0 0,grow");
        this.cavePanel = this.drawCave();
        actionPanel.add((Component)this.cavePanel, "cell 1 0,grow");
        this.sensorPanel = this.drawSensorPanel();
        this.frame.getContentPane().add((Component)this.sensorPanel, "cell 0 2,grow");
        JPanel blank = new JPanel();
        blank.setBackground(Color.WHITE);
        this.frame.getContentPane().add((Component)blank, "cell 0 3,grow");
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.updateCave();
        this.updateSensors();
    }

    public synchronized void updateCave() {
        this.cavePanel.repaint();
        this.cavePanel.revalidate();
    }

    public synchronized void updateSensors() {
        this.sensorPanel.repaint();
        this.sensorPanel.revalidate();
    }

    public SensorPanel drawSensorPanel() {
        SensorPanel sensorPanel = new SensorPanel(this);
        FlowLayout flowLayout = (FlowLayout)sensorPanel.getLayout();
        flowLayout.setVgap(10);
        sensorPanel.setBackground(Color.WHITE);
        return sensorPanel;
    }

    public CavePanel drawCave() {
        CavePanel cavelPanel = new CavePanel(this);
        FlowLayout flowLayout = (FlowLayout)cavelPanel.getLayout();
        flowLayout.setVgap(10);
        cavelPanel.setBackground(Color.WHITE);
        return cavelPanel;
    }

    public JPanel drawActionPanel() {
        JPanel actionPanel = new JPanel();
        actionPanel.setBackground(Color.WHITE);
        actionPanel.setLayout(new GridLayout(0, 2, 0, 0));
        JButton restartButton = new JButton("RESTART");
        restartButton.setToolTipText("Restart game");
        restartButton.setBackground(Color.LIGHT_GRAY);
        restartButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Reset reset = new Reset();
                reset.setResetScore(true);
                GameUI.this.gameView.getKsession().insert((Object)reset);
                GameUI.this.gameView.getKsession().fireAllRules();
            }
        });
        actionPanel.add(restartButton);
        JButton shootButton = new JButton("SHOOT");
        shootButton.setToolTipText("Shoot Arrow");
        shootButton.setBackground(Color.LIGHT_GRAY);
        shootButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GameUI.this.gameView.getKsession().insert((Object)new ShootCommand());
                GameUI.this.gameView.getKsession().fireAllRules();
            }
        });
        actionPanel.add(shootButton);
        JButton grabButton = new JButton("GRAB");
        grabButton.setToolTipText("Grab gold");
        grabButton.setBackground(Color.LIGHT_GRAY);
        grabButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GameUI.this.gameView.getKsession().insert((Object)new GrabCommand());
                GameUI.this.gameView.getKsession().fireAllRules();
            }
        });
        actionPanel.add(grabButton);
        JButton climbButton = new JButton("CLIMB");
        climbButton.setToolTipText("Climb out of the cave");
        climbButton.setBackground(Color.LIGHT_GRAY);
        climbButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GameUI.this.gameView.getKsession().insert((Object)new ClimbCommand());
                GameUI.this.gameView.getKsession().fireAllRules();
            }
        });
        actionPanel.add(climbButton);
        final JButton showCaveButton = new JButton("HIDE");
        showCaveButton.setToolTipText("Hide/Show the cave");
        showCaveButton.setBackground(Color.LIGHT_GRAY);
        showCaveButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (GameUI.this.cavePanel.isVisible()) {
                    GameUI.this.cavePanel.setVisible(false);
                    showCaveButton.setText("SHOW");
                } else {
                    GameUI.this.cavePanel.setVisible(true);
                    showCaveButton.setText("HIDE");
                }
            }
        });
        actionPanel.add(showCaveButton);
        JButton cheatButton = new JButton("CHEAT");
        cheatButton.setToolTipText("Reveal all squares");
        cheatButton.setBackground(Color.LIGHT_GRAY);
        cheatButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                FactHandle fh = GameUI.this.gameView.getKsession().getFactHandle((Object)GameUI.this.gameView);
                if (GameUI.this.gameView.isShowAllCells()) {
                    GameUI.this.gameView.setShowAllCells(false);
                } else {
                    GameUI.this.gameView.setShowAllCells(true);
                }
                GameUI.this.gameView.getKsession().update(fh, (Object)GameUI.this.gameView);
                GameUI.this.gameView.getKsession().fireAllRules();
            }
        });
        actionPanel.add(cheatButton);
        return actionPanel;
    }

    public JPanel drawMovePanel() {
        JPanel movePanel = new JPanel();
        movePanel.setBackground(Color.WHITE);
        movePanel.setLayout(new GridLayout(0, 3, 0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBackground(Color.WHITE);
        movePanel.add(panel_2);
        JButton btnNewButton = new JButton("");
        btnNewButton.setForeground(Color.WHITE);
        btnNewButton.setBackground(Color.WHITE);
        btnNewButton.setIcon(new ImageIcon(this.getClass().getResource("up.png")));
        btnNewButton.setToolTipText("move forward");
        btnNewButton.addMouseListener(new MoveButtonPressed(Move.MOVE_FORWARD));
        movePanel.add(btnNewButton);
        JPanel panel_7 = new JPanel();
        panel_7.setBackground(Color.WHITE);
        movePanel.add(panel_7);
        JButton btnNewButton_3 = new JButton("");
        btnNewButton_3.setForeground(Color.WHITE);
        btnNewButton_3.setBackground(Color.WHITE);
        btnNewButton_3.setIcon(new ImageIcon(this.getClass().getResource("rotate_left.png")));
        btnNewButton_3.addMouseListener(new MoveButtonPressed(Move.TURN_LEFT));
        btnNewButton_3.setToolTipText("rotate left");
        movePanel.add(btnNewButton_3);
        JPanel panel_8 = new JPanel();
        panel_8.setBackground(Color.WHITE);
        movePanel.add(panel_8);
        JButton btnNewButton_2 = new JButton("");
        btnNewButton_2.setForeground(Color.WHITE);
        btnNewButton_2.setBackground(Color.WHITE);
        btnNewButton_2.setIcon(new ImageIcon(this.getClass().getResource("rotate_right.png")));
        btnNewButton_2.addMouseListener(new MoveButtonPressed(Move.TURN_RIGHT));
        btnNewButton_2.setToolTipText("rotate right");
        movePanel.add(btnNewButton_2);
        JPanel panel_9 = new JPanel();
        panel_9.setBackground(Color.WHITE);
        movePanel.add(panel_9);
        JButton btnNewButton_1 = new JButton("");
        btnNewButton_1.setForeground(Color.WHITE);
        btnNewButton_1.setBackground(Color.WHITE);
        btnNewButton_1.setIcon(new ImageIcon(this.getClass().getResource("down.png")));
        btnNewButton_1.addMouseListener(new MoveButtonPressed(Move.MOVE_BACKWARD));
        btnNewButton_1.setToolTipText("move backward");
        movePanel.add(btnNewButton_1);
        JPanel panel_10 = new JPanel();
        panel_10.setBackground(Color.WHITE);
        movePanel.add(panel_10);
        return movePanel;
    }

    public static class CavePanel
    extends JPanel {
        private GameUI gameUI;
        private BufferedImage bi;
        private Graphics caveG;

        public CavePanel(GameUI gameUI) {
            this.setOpaque(true);
            this.gameUI = gameUI;
        }

        public Graphics getCaveG() {
            return this.caveG;
        }

        protected void paintComponent(Graphics g) {
            if (this.bi == null) {
                this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                this.caveG = this.bi.createGraphics();
                this.caveG.setColor(Color.WHITE);
                this.caveG.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.gameUI != null) {
                    this.gameUI.getGameView().getKsession().update(this.gameUI.getGameView().getKsession().getFactHandle((Object)this.gameUI), (Object)this.gameUI);
                    this.gameUI.getGameView().getKsession().fireAllRules();
                }
            }
            g.drawImage(this.bi, 0, 0, null);
        }
    }

    public static class SensorPanel
    extends JPanel {
        private GameUI gameUI;
        private BufferedImage bi;
        private Graphics sensorG;

        public SensorPanel(GameUI gameUI) {
            this.setOpaque(true);
            this.gameUI = gameUI;
        }

        public Graphics getSensorG() {
            return this.sensorG;
        }

        protected void paintComponent(Graphics g) {
            if (this.bi == null) {
                this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                this.sensorG = this.bi.createGraphics();
                this.sensorG.setColor(Color.WHITE);
                this.sensorG.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.gameUI != null) {
                    this.gameUI.getGameView().getKsession().update(this.gameUI.getGameView().getKsession().getFactHandle((Object)this.gameUI), (Object)this.gameUI);
                    this.gameUI.getGameView().getKsession().fireAllRules();
                }
            }
            g.drawImage(this.bi, 0, 0, null);
        }
    }

    private final class MoveButtonPressed
    extends MouseAdapter {
        private Move move;

        public MoveButtonPressed(Move move) {
            this.move = move;
        }

        public void mousePressed(MouseEvent e) {
            GameUI.this.gameView.getKsession().insert((Object)new MoveCommand(this.move));
            GameUI.this.gameView.getKsession().fireAllRules();
        }
    }
}

