/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.waltzdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.benchmark.waltzdb.Label;
import org.drools.benchmark.waltzdb.Line;
import org.drools.benchmark.waltzdb.Stage;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.util.IoUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class WaltzDbBenchmark {
    public static void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"waltzdb.drl", WaltzDbBenchmark.class), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        KieBaseConfiguration kbaseConfiguration = RuleBaseFactory.newKnowledgeBaseConfiguration();
        kbaseConfiguration.setProperty("drools.removeIdentities", "true");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbaseConfiguration);
        kbase.addPackages(pkgs);
        KieSession ksession = kbase.newKieSession();
        List<Line> lines = WaltzDbBenchmark.loadLines("waltzdb16.dat");
        List<Label> labels = WaltzDbBenchmark.loadLabels("waltzdb16.dat");
        long now = System.currentTimeMillis();
        for (Line line : lines) {
            ksession.insert((Object)line);
            System.out.println(line.getP1() + " " + line.getP2());
        }
        for (Label label : labels) {
            ksession.insert((Object)label);
            System.out.println(label.getId() + " " + label.getType());
        }
        Stage stage = new Stage("A");
        ksession.insert((Object)stage);
        ksession.fireAllRules();
        System.out.println("Time: " + (System.currentTimeMillis() - now));
        ksession.dispose();
    }

    private static List<Line> loadLines(String filename) {
        ArrayList<Line> result = new ArrayList<Line>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(WaltzDbBenchmark.class.getResourceAsStream("data/" + filename), IoUtils.UTF8_CHARSET));
            Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
            String line = reader.readLine();
            while (line != null) {
                Matcher m = pat.matcher(line);
                if (m.matches()) {
                    Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                    result.add(l);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file with filename (" + filename + ").", e);
        }
        return result;
    }

    private static List<Label> loadLabels(String filename) {
        ArrayList<Label> result = new ArrayList<Label>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(WaltzDbBenchmark.class.getResourceAsStream("data/" + filename), IoUtils.UTF8_CHARSET));
            Pattern pat = Pattern.compile(".*make label \\^type ([0-9a-z]*) \\^name ([0-9a-zA-Z]*) \\^id ([0-9]*) \\^n1 ([B+-]*) \\^n2 ([B+-]*)( \\^n3 ([B+-]*))?.*");
            String line = reader.readLine();
            while (line != null) {
                Matcher m = pat.matcher(line);
                if (m.matches()) {
                    Label l = new Label(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6));
                    result.add(l);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file with filename (" + filename + ").", e);
        }
        return result;
    }
}

