/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ConditionalElement;
import org.drools.base.rule.Declaration;
import org.drools.base.time.JobHandle;
import org.drools.base.time.Trigger;
import org.drools.base.time.impl.Timer;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.CompositeMaxDurationTrigger;
import org.drools.core.time.impl.DurationTimer;
import org.kie.api.runtime.Calendars;

public class CompositeMaxDurationTimer
extends BaseTimer
implements Timer {
    private static final long serialVersionUID = -2531364489959820962L;
    private List<DurationTimer> durations;
    private Timer timer;

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return null;
    }

    public void addDurationTimer(DurationTimer durationTimer) {
        if (this.durations == null) {
            this.durations = new ArrayList<DurationTimer>();
        }
        this.durations.add(durationTimer);
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Trigger createTrigger(InternalMatch item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        return this.createTrigger(this.getMaxTimestamp(item.getTuple(), timestamp), calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, BaseTuple leftTuple, JobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, ValueResolver valueResolver) {
        return this.createTrigger(this.getMaxTimestamp(leftTuple, timestamp), calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        if (this.durations == null) {
            throw new IllegalStateException("CompositeMaxDurationTimer cannot have no durations");
        }
        Date maxDurationDate = new Date(this.timer != null ? this.getMaxDuration() + timestamp : timestamp);
        return new CompositeMaxDurationTrigger(maxDurationDate, this.timer != null ? this.timer.createTrigger(timestamp, calendarNames, calendars) : null);
    }

    private long getMaxTimestamp(BaseTuple leftTuple, long timestamp) {
        if (this.timer != null) {
            return timestamp;
        }
        long result = 0L;
        for (DurationTimer durationTimer : this.durations) {
            result = Math.max(result, durationTimer.getDuration() + durationTimer.getEventTimestamp(leftTuple, timestamp));
        }
        return result;
    }

    private long getMaxDuration() {
        long result = 0L;
        for (DurationTimer durationTimer : this.durations) {
            result = Math.max(result, durationTimer.getDuration());
        }
        return result;
    }

    @Override
    public ConditionalElement clone() {
        CompositeMaxDurationTimer clone = new CompositeMaxDurationTimer();
        if (this.durations != null && !this.durations.isEmpty()) {
            for (DurationTimer timer : this.durations) {
                clone.addDurationTimer(timer);
            }
        }
        if (this.timer != null) {
            clone.timer = this.timer;
        }
        return clone;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.durations);
        out.writeObject(this.timer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.durations = (List)in.readObject();
        this.timer = (Timer)in.readObject();
    }
}

