/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.base.rule.EntryPointId;
import org.drools.base.time.JobHandle;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.util.LinkedList;
import org.kie.api.runtime.rule.EventHandle;

public class DefaultEventHandle
extends DefaultFactHandle
implements EventHandle,
Comparable<DefaultEventHandle> {
    private static final long serialVersionUID = 510L;
    static final String EVENT_FORMAT_VERSION = "5";
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private boolean pendingRemoveFromStore;
    private int otnCount;
    private DefaultEventHandle linkedFactHandle;
    private final transient LinkedList<DefaultJobHandle> jobs = new LinkedList();

    public DefaultEventHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public DefaultEventHandle(long id, EntryPointId entryPointId) {
        super(id, null);
        this.startTimestamp = 0L;
        this.duration = 0L;
        this.entryPointId = entryPointId;
    }

    public DefaultEventHandle(long id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint) {
        super(id, object, recency, wmEntryPoint);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    protected DefaultEventHandle(long id, int identityHashCode, Object object, long recency, long timestamp, long duration, EntryPointId entryPointId) {
        super(id, identityHashCode, object, recency, entryPointId);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    @Override
    protected String getFormatVersion() {
        return EVENT_FORMAT_VERSION;
    }

    @Override
    public String toString() {
        return this.toExternalForm();
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public DefaultEventHandle getLinkedFactHandle() {
        return this.linkedFactHandle;
    }

    @Override
    public void invalidate() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.invalidate();
        } else {
            super.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isValid();
        }
        return super.isValid();
    }

    @Override
    public boolean isExpired() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isExpired();
        }
        return this.expired;
    }

    public void setExpired(boolean expired) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setExpired(expired);
        } else {
            this.expired = expired;
        }
    }

    @Override
    public boolean isPendingRemoveFromStore() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isPendingRemoveFromStore();
        }
        return this.pendingRemoveFromStore;
    }

    public void setPendingRemoveFromStore(boolean pendingRemove) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setPendingRemoveFromStore(pendingRemove);
        } else {
            this.pendingRemoveFromStore = pendingRemove;
        }
    }

    public void increaseOtnCount() {
        ++this.otnCount;
    }

    public void decreaseOtnCount() {
        --this.otnCount;
    }

    public int getOtnCount() {
        return this.otnCount;
    }

    public void setOtnCount(int otnCount) {
        this.otnCount = otnCount;
    }

    @Override
    public DefaultEventHandle clone() {
        DefaultEventHandle clone = new DefaultEventHandle(this.getId(), this.getIdentityHashCode(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPointId());
        clone.setOtnCount(this.getOtnCount());
        clone.setExpired(this.isExpired());
        clone.setEqualityKey(this.getEqualityKey());
        clone.linkedTuples = this.linkedTuples.clone();
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.wmEntryPoint = this.wmEntryPoint;
        return clone;
    }

    private DefaultEventHandle cloneWithoutTuples() {
        DefaultEventHandle clone = new DefaultEventHandle(this.getId(), this.getIdentityHashCode(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPointId());
        clone.setOtnCount(this.getOtnCount());
        clone.setExpired(this.isExpired());
        clone.setEqualityKey(this.getEqualityKey());
        clone.linkedTuples = this.linkedTuples.cloneEmpty();
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.wmEntryPoint = this.wmEntryPoint;
        return clone;
    }

    public DefaultEventHandle cloneAndLink() {
        DefaultEventHandle clone = this.cloneWithoutTuples();
        clone.linkedFactHandle = this;
        return clone;
    }

    public void quickCloneUpdate(DefaultFactHandle clone) {
        clone.setObject(this.getObject());
        clone.setRecency(this.getRecency());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.setIdentityHashCode(this.getIdentityHashCode());
        clone.setTraitType(this.getTraitType());
        clone.setDisconnected(this.isDisconnected());
        clone.setNegated(this.isNegated());
    }

    @Override
    public int compareTo(DefaultEventHandle e) {
        return this.getStartTimestamp() < e.getStartTimestamp() ? -1 : (this.getStartTimestamp() == e.getStartTimestamp() ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(DefaultJobHandle job) {
        LinkedList<DefaultJobHandle> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(DefaultJobHandle job) {
        LinkedList<DefaultJobHandle> linkedList = this.jobs;
        synchronized (linkedList) {
            if (this.jobs.contains(job)) {
                this.jobs.remove(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleAllJobs(ReteEvaluator reteEvaluator) {
        if (!this.jobs.isEmpty()) {
            LinkedList<DefaultJobHandle> linkedList = this.jobs;
            synchronized (linkedList) {
                TimerService clock = reteEvaluator.getTimerService();
                while (!this.jobs.isEmpty()) {
                    JobHandle job = this.jobs.removeFirst();
                    clock.removeJob(job);
                }
            }
        }
    }
}

