/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class IntegerSumAccumulateFunction
extends AbstractAccumulateFunction<SumData> {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public SumData createContext() {
        return new SumData();
    }

    @Override
    public void init(SumData data) {
        data.total = 0;
    }

    @Override
    public void accumulate(SumData data, Object value) {
        if (value != null) {
            data.total += ((Integer)value).intValue();
        }
    }

    @Override
    public void reverse(SumData data, Object value) {
        if (value != null) {
            data.total -= ((Integer)value).intValue();
        }
    }

    @Override
    public Object getResult(SumData data) {
        return data.total;
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Integer.class;
    }

    protected static class SumData
    implements Externalizable {
        public int total = 0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.total);
        }
    }
}

