/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.factmodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.util.TypeResolver;
import org.kie.api.definition.type.Annotation;
import org.kie.api.definition.type.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDefinition
implements Externalizable,
Annotation {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationDefinition.class);
    private String name;
    private Map<String, AnnotationPropertyVal> values;

    public AnnotationDefinition() {
    }

    public AnnotationDefinition(String name) {
        this.name = name;
        this.values = new HashMap<String, AnnotationPropertyVal>();
    }

    public Map<String, AnnotationPropertyVal> getValues() {
        return this.values;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.values = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationDefinition that = (AnnotationDefinition)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.values != null ? this.values.equals(that.values) : that.values == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "@" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getPropertyValue(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).getValue();
        }
        return null;
    }

    @Override
    public Class getPropertyType(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).getType();
        }
        return null;
    }

    public static AnnotationDefinition build(Class annotationClass, Map<String, Object> valueMap, TypeResolver resolver) throws NoSuchMethodException {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(annotationClass.getName());
        HashMap<String, AnnotationPropertyVal> values = new HashMap<String, AnnotationPropertyVal>();
        for (Map.Entry<String, Object> valueMapEntry : valueMap.entrySet()) {
            AnnotationPropertyVal value = AnnotationDefinition.rebuild(valueMapEntry.getKey(), annotationClass, valueMapEntry.getValue(), resolver);
            values.put(valueMapEntry.getKey(), value);
        }
        annotationDefinition.values = Collections.unmodifiableMap(values);
        return annotationDefinition;
    }

    private static AnnotationPropertyVal rebuild(String key, Class annotationClass, Object value, TypeResolver resolver) throws NoSuchMethodException {
        if (annotationClass == Role.class) {
            return new AnnotationPropertyVal(key, Role.Type.class, (Object)(value != null && value.toString().equalsIgnoreCase("event") ? Role.Type.EVENT : Role.Type.FACT), AnnotationPropertyVal.ValType.ENUMERATION);
        }
        Method prop = annotationClass.getMethod(key, new Class[0]);
        Class<?> returnType = prop.getReturnType();
        Object val = AnnotationDefinition.decode(returnType, value, resolver);
        AnnotationPropertyVal.ValType valType = returnType.isPrimitive() ? AnnotationPropertyVal.ValType.PRIMITIVE : (returnType.isEnum() ? AnnotationPropertyVal.ValType.ENUMERATION : (returnType.isArray() ? (returnType.getComponentType().isEnum() ? AnnotationPropertyVal.ValType.ENUMARRAY : (returnType.getComponentType().isPrimitive() ? AnnotationPropertyVal.ValType.PRIMARRAY : (String.class.equals(returnType.getComponentType()) ? AnnotationPropertyVal.ValType.STRINGARRAY : AnnotationPropertyVal.ValType.CLASSARRAY))) : (String.class.equals(returnType) ? AnnotationPropertyVal.ValType.STRING : AnnotationPropertyVal.ValType.KLASS)));
        return new AnnotationPropertyVal(key, returnType, val, valType);
    }

    private static Object decode(Class returnType, Object value, TypeResolver resolver) {
        if (returnType.isArray()) {
            int n = Array.getLength(value);
            Class targetType = returnType.getComponentType().isAnnotation() ? AnnotationDefinition.class : returnType.getComponentType();
            Object ar = Array.newInstance(targetType, n);
            for (int j = 0; j < n; ++j) {
                Array.set(ar, j, AnnotationDefinition.decode(returnType.getComponentType(), Array.get(value, j), resolver));
            }
            return ar;
        }
        if (returnType.isEnum()) {
            if (returnType.isAssignableFrom(value.getClass())) {
                return value;
            }
            try {
                String valueStr = value.toString().trim();
                if (valueStr.indexOf(46) > 0) {
                    value = valueStr.substring(valueStr.lastIndexOf(".") + 1);
                }
                return returnType.getMethod("valueOf", String.class).invoke(null, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (String.class.equals((Object)returnType)) {
            return AnnotationDefinition.unquote(value.toString().trim());
        }
        if (Boolean.TYPE.equals(returnType)) {
            return Boolean.valueOf(value.toString());
        }
        if (Integer.TYPE.equals(returnType)) {
            return Integer.valueOf(value.toString());
        }
        if (Double.TYPE.equals(returnType)) {
            return Double.valueOf(value.toString());
        }
        if (Long.TYPE.equals(returnType)) {
            return Long.valueOf(value.toString());
        }
        if (Float.TYPE.equals(returnType)) {
            return Float.valueOf(value.toString());
        }
        if (Short.TYPE.equals(returnType)) {
            return Short.valueOf(value.toString());
        }
        if (Character.TYPE.equals(returnType)) {
            return Character.valueOf(AnnotationDefinition.unquote(value.toString()).charAt(0));
        }
        if (Class.class.equals((Object)returnType)) {
            if (value instanceof Class) {
                return value;
            }
            try {
                String cName = value.toString().trim().replace(".class", "");
                return resolver.resolveType(cName);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Exception", cnfe);
                return Object.class;
            }
        }
        if (returnType.isAnnotation()) {
            try {
                return AnnotationDefinition.build(returnType, (Map)((Supplier)value).get(), resolver);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Exception", e);
                return null;
            }
        }
        return null;
    }

    public static String unquote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static class AnnotationPropertyVal
    implements Externalizable {
        private String property;
        private Class type;
        private Object value;
        private ValType valType;

        public AnnotationPropertyVal() {
        }

        public AnnotationPropertyVal(String property, Class type, Object value, ValType valType) {
            this.property = property;
            this.type = type;
            this.value = value;
            this.valType = valType;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.property = (String)in.readObject();
            this.type = (Class)in.readObject();
            this.value = in.readObject();
            this.valType = (ValType)((Object)in.readObject());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.property);
            out.writeObject(this.type);
            out.writeObject(this.value);
            out.writeObject((Object)this.valType);
        }

        public String toString() {
            return "PropertyVal{property='" + this.property + "', type=" + this.type + ", value=" + this.value + ", valType=" + this.valType + "}";
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public Class getType() {
            return this.type;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public ValType getValType() {
            return this.valType;
        }

        public void setValType(ValType valType) {
            this.valType = valType;
        }

        public static enum ValType {
            PRIMITIVE,
            KLASS,
            STRING,
            ENUMERATION,
            STRINGARRAY,
            ENUMARRAY,
            PRIMARRAY,
            CLASSARRAY,
            ANNOTATION;

        }
    }
}

