/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.base.SalienceInteger;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.consequence.Consequence;
import org.drools.base.rule.consequence.ConsequenceException;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalActivationGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.conflict.MatchConflictResolver;
import org.drools.core.conflict.RuleAgendaConflictResolver;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.util.Queue;
import org.drools.core.util.QueueFactory;
import org.drools.core.util.index.TupleList;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.AgendaFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    protected static final Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private final PathMemory pmem;
    private final RuleAgendaItem ruleAgendaItem;
    private final TupleList tupleList;
    private final Queue<InternalMatch> queue;
    private volatile boolean dirty;
    private final boolean declarativeAgendaEnabled;
    private boolean fireExitedEarly;

    public RuleExecutor(PathMemory pmem, RuleAgendaItem ruleAgendaItem, boolean declarativeAgendaEnabled) {
        this.pmem = pmem;
        this.ruleAgendaItem = ruleAgendaItem;
        this.tupleList = new TupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        this.queue = ruleAgendaItem.getRule().getSalience().isDynamic() ? QueueFactory.createQueue(MatchConflictResolver.INSTANCE) : null;
    }

    public int evaluateNetworkAndFire(ReteEvaluator reteEvaluator, AgendaFilter filter, int fireCount, int fireLimit) {
        this.evaluateNetworkIfDirty(reteEvaluator);
        return this.fire(reteEvaluator, this.pmem.getActualActivationsManager(reteEvaluator), filter, fireCount, fireLimit);
    }

    public int evaluateNetworkAndFire(ActivationsManager activationsManager, AgendaFilter filter, int fireCount, int fireLimit) {
        this.evaluateNetworkIfDirty(activationsManager);
        ReteEvaluator reteEvaluator = activationsManager.getReteEvaluator();
        if (reteEvaluator.getRuleSessionConfiguration().isDirectFiring()) {
            return this.doDirectFirings(activationsManager, filter, reteEvaluator);
        }
        return this.fire(reteEvaluator, activationsManager, filter, fireCount, fireLimit);
    }

    private int doDirectFirings(ActivationsManager activationsManager, AgendaFilter filter, ReteEvaluator reteEvaluator) {
        RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getPathEndNode();
        int directFirings = this.tupleList.size();
        Tuple tuple = this.tupleList.getFirst();
        while (tuple != null) {
            if (this.cancelAndContinue(reteEvaluator, rtn, tuple, filter)) {
                --directFirings;
            } else {
                this.fireActivationEvent(reteEvaluator, activationsManager, (InternalMatch)((Object)tuple), ((InternalMatch)((Object)tuple)).getConsequence());
            }
            this.removeLeftTuple(tuple);
            tuple = this.tupleList.getFirst();
        }
        this.ruleAgendaItem.remove();
        return directFirings;
    }

    public void fire(ActivationsManager activationsManager) {
        this.fire(activationsManager.getReteEvaluator(), activationsManager, null, 0, Integer.MAX_VALUE);
    }

    public int fire(ActivationsManager activationsManager, AgendaFilter filter, int fireCount, int fireLimit) {
        return this.fire(activationsManager.getReteEvaluator(), activationsManager, filter, fireCount, fireLimit);
    }

    private int fire(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, AgendaFilter filter, int fireCount, int fireLimit) {
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleAgendaItem nextRule;
            if (!this.fireExitedEarly && this.isDeclarativeAgendaEnabled() && !this.isHigherSalience(nextRule = activationsManager.peekNextRule())) {
                this.fireExitedEarly = true;
                return localFireCount;
            }
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getPathEndNode();
            boolean ruleIsAllMatches = rtn.getRule().isAllMatches();
            Tuple tuple = this.getNextTuple();
            if (ruleIsAllMatches) {
                this.fireConsequenceEvent(reteEvaluator, activationsManager, (InternalMatch)((Object)tuple), "$onBeforeAllFire$");
            }
            Tuple lastTuple = null;
            while (tuple != null) {
                if (!this.cancelAndContinue(reteEvaluator, rtn, tuple, filter)) {
                    InternalMatch item = (InternalMatch)((Object)tuple);
                    if (activationsManager.getActivationsFilter() == null || activationsManager.getActivationsFilter().accept(item)) {
                        this.fireActivation(reteEvaluator, activationsManager, item);
                        ++localFireCount;
                        if (rtn.getLeftTupleSource() == null) break;
                        activationsManager.flushPropagations();
                        int salience = this.ruleAgendaItem.getSalience();
                        if (this.queue != null && !this.queue.isEmpty() && salience != this.queue.peek().getSalience()) {
                            this.ruleAgendaItem.dequeue();
                            this.ruleAgendaItem.setSalience(this.queue.peek().getSalience());
                            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
                        }
                        if (!ruleIsAllMatches) {
                            if (this.haltRuleFiring(fireCount, fireLimit, localFireCount, activationsManager)) break;
                            if (!reteEvaluator.isSequential()) {
                                this.evaluateNetworkIfDirty(activationsManager);
                            }
                        }
                    }
                }
                lastTuple = tuple;
                tuple = this.getNextTuple();
            }
            if (ruleIsAllMatches) {
                this.fireConsequenceEvent(reteEvaluator, activationsManager, (InternalMatch)((Object)lastTuple), "$onAfterAllFire$");
            }
        }
        this.removeRuleAgendaItemWhenEmpty(reteEvaluator);
        this.fireExitedEarly = false;
        return localFireCount;
    }

    private Tuple getNextTuple() {
        Tuple leftTuple;
        if (this.tupleList.isEmpty()) {
            return null;
        }
        if (this.queue != null) {
            leftTuple = (Tuple)((Object)this.queue.dequeue());
            this.tupleList.remove(leftTuple);
        } else {
            leftTuple = this.tupleList.removeFirst();
            ((InternalMatch)((Object)leftTuple)).setQueued(false);
        }
        return leftTuple;
    }

    public PathMemory getPathMemory() {
        return this.pmem;
    }

    public void removeRuleAgendaItemWhenEmpty(ReteEvaluator reteEvaluator) {
        if (!this.dirty && this.tupleList.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Removing RuleAgendaItem " + this.ruleAgendaItem);
            }
            this.ruleAgendaItem.remove();
            if (this.ruleAgendaItem.getRule().isQuery()) {
                this.pmem.getActualActivationsManager(reteEvaluator).removeQueryAgendaItem(this.ruleAgendaItem);
            } else if (this.ruleAgendaItem.getRule().isEager()) {
                this.pmem.getActualActivationsManager(reteEvaluator).removeEagerRuleAgendaItem(this.ruleAgendaItem);
            }
        }
    }

    public void evaluateNetwork(ActivationsManager activationsManager) {
        RuleNetworkEvaluator.INSTANCE.evaluateNetwork(this.pmem, this, activationsManager);
        this.setDirty(false);
    }

    public void evaluateNetworkIfDirty(ReteEvaluator reteEvaluator) {
        this.evaluateNetworkIfDirty(this.pmem.getActualActivationsManager(reteEvaluator));
    }

    public void evaluateNetworkIfDirty(ActivationsManager activationsManager) {
        if (this.isDirty()) {
            this.evaluateNetwork(activationsManager);
        }
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    private boolean cancelAndContinue(ReteEvaluator reteEvaluator, RuleTerminalNode rtn, Tuple leftTuple, AgendaFilter filter) {
        RuleImpl rule = rtn.getRule();
        if (!rule.isEffective(leftTuple, rtn.getEnabledDeclarations(), reteEvaluator)) {
            return true;
        }
        if (rule.hasCalendars()) {
            long timestamp = reteEvaluator.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (reteEvaluator.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return filter != null && !filter.accept((InternalMatch)((Object)leftTuple));
    }

    private boolean haltRuleFiring(int fireCount, int fireLimit, int localFireCount, ActivationsManager activationsManager) {
        if (!activationsManager.isFiring() || fireLimit >= 0 && localFireCount + fireCount >= fireLimit) {
            return true;
        }
        activationsManager.evaluateEagerList();
        RuleAgendaItem nextRule = activationsManager.peekNextRule();
        if (nextRule == this.ruleAgendaItem || nextRule == null) {
            return false;
        }
        return !this.ruleAgendaItem.getAgendaGroup().equals(nextRule.getAgendaGroup()) || !this.isHigherSalience(nextRule);
    }

    private boolean isHigherSalience(RuleAgendaItem nextRule) {
        return RuleAgendaConflictResolver.doCompare(this.ruleAgendaItem, nextRule) >= 0;
    }

    public TupleList getLeftTupleList() {
        return this.tupleList;
    }

    public void addLeftTuple(Tuple tuple) {
        ((InternalMatch)((Object)tuple)).setQueued(true);
        this.tupleList.add(tuple);
        if (this.queue != null) {
            this.addQueuedLeftTuple(tuple);
        }
    }

    public void addQueuedLeftTuple(Tuple tuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.enqueue((InternalMatch)((Object)tuple));
        this.updateSalience(currentSalience);
    }

    public void removeLeftTuple(Tuple tuple) {
        ((InternalMatch)((Object)tuple)).setQueued(false);
        this.tupleList.remove(tuple);
        if (this.queue != null) {
            this.removeQueuedLeftTuple(tuple);
        }
    }

    private void removeQueuedLeftTuple(Tuple tuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.dequeue((InternalMatch)((Object)tuple));
        this.updateSalience(currentSalience);
    }

    private void updateSalience(int currentSalience) {
        int newSalience;
        int n = newSalience = this.queue.isEmpty() ? SalienceInteger.DEFAULT_SALIENCE.getValue() : this.queue.peek().getSalience();
        if (currentSalience != newSalience) {
            this.ruleAgendaItem.remove();
        }
        if (!this.ruleAgendaItem.isQueued()) {
            this.ruleAgendaItem.setSalience(newSalience);
            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
        }
    }

    public void cancel(ReteEvaluator reteEvaluator, EventSupport es) {
        while (!this.tupleList.isEmpty()) {
            RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)this.tupleList.removeFirst();
            if (this.queue != null) {
                this.queue.dequeue(rtnLt);
            }
            es.getAgendaEventSupport().fireActivationCancelled(rtnLt, reteEvaluator, MatchCancelledCause.CLEAR);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    public void fireActivation(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, InternalMatch internalMatch) throws ConsequenceException {
        BeforeMatchFiredEvent beforeMatchFiredEvent = activationsManager.getAgendaEventSupport().fireBeforeActivationFired(internalMatch, reteEvaluator);
        if (internalMatch.getActivationGroupNode() != null) {
            InternalActivationGroup activationGroup = internalMatch.getActivationGroupNode().getActivationGroup();
            activationGroup.removeActivation(internalMatch);
            activationsManager.clearAndCancelActivationGroup(activationGroup);
        }
        internalMatch.setQueued(false);
        this.fireActivationEvent(reteEvaluator, activationsManager, internalMatch, internalMatch.getConsequence());
        activationsManager.getAgendaEventSupport().fireAfterActivationFired(internalMatch, reteEvaluator, beforeMatchFiredEvent);
    }

    public void fireConsequenceEvent(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, InternalMatch internalMatch, String consequenceName) {
        Consequence consequence = internalMatch.getRule().getNamedConsequence(consequenceName);
        if (consequence != null) {
            this.fireActivationEvent(reteEvaluator, activationsManager, internalMatch, consequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActivationEvent(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, InternalMatch internalMatch, Consequence consequence) {
        KnowledgeHelper knowledgeHelper = activationsManager.getKnowledgeHelper();
        try {
            knowledgeHelper.setActivation(internalMatch);
            if (log.isTraceEnabled()) {
                log.trace("Fire event {} for rule \"{}\" \n{}", consequence.getName(), internalMatch.getRule().getName(), internalMatch.getTuple());
            }
            RuleEventListenerSupport ruleEventSupport = reteEvaluator.getRuleEventSupport();
            ruleEventSupport.onBeforeMatchFire(internalMatch);
            consequence.evaluate(knowledgeHelper, reteEvaluator);
            ruleEventSupport.onAfterMatchFire(internalMatch);
            internalMatch.setActive(false);
            knowledgeHelper.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
            knowledgeHelper.restoreActivationOnConsequenceFailure(internalMatch);
            activationsManager.handleException(internalMatch, e);
        }
        finally {
            if (internalMatch.getActivationFactHandle() != null) {
                InternalFactHandle factHandle = internalMatch.getActivationFactHandle();
                reteEvaluator.getDefaultEntryPoint().getEntryPointNode().modifyActivation(factHandle, internalMatch.getPropagationContext(), reteEvaluator);
            }
        }
    }
}

