/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.index.TupleList;

public class PhreakSubnetworkNotExistsNode {
    public static void doSubNetworkNode(BetaNode node, LeftTupleSink sink, BetaMemory bm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
        TupleMemory ltm = bm.getLeftTupleMemory();
        boolean tupleMemoryEnabled = node.isLeftTupleMemoryEnabled();
        PhreakSubnetworkNotExistsNode.deleteLeft(srcLeftTuples, trgLeftTuples, stagedLeftTuples, ltm);
        PhreakSubnetworkNotExistsNode.insertRight(node, sink, trgLeftTuples, stagedLeftTuples, srcRightTuples, tupleMemoryEnabled);
        PhreakSubnetworkNotExistsNode.insertLeft(node, sink, srcLeftTuples, trgLeftTuples, ltm, tupleMemoryEnabled);
        PhreakSubnetworkNotExistsNode.updateRight(srcRightTuples);
        PhreakSubnetworkNotExistsNode.deleteRight(node, sink, trgLeftTuples, stagedLeftTuples, srcRightTuples);
        PhreakSubnetworkNotExistsNode.updateLeft(srcLeftTuples, trgLeftTuples, stagedLeftTuples, ltm);
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    private static void updateLeft(TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, TupleMemory ltm) {
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            if (!leftTuple.isExpired() && childLeftTuple != null && childLeftTuple.getStagedType() == 0) {
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private static void deleteRight(BetaNode node, LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, TupleSets<RightTuple> srcRightTuples) {
        if (srcRightTuples.getDeleteFirst() != null) {
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = (RightTuple)rightTuple.getStagedNext();
                LeftTuple leftTuple = node.getStartTuple((SubnetworkTuple)rightTuple);
                rightTuple.getMemory().remove(rightTuple);
                TupleList matches = (TupleList)leftTuple.getContextObject();
                if (matches != null && matches.isEmpty()) {
                    if (node.getType() == 201) {
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    } else if (!leftTuple.isExpired()) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }

    private static void updateRight(TupleSets<RightTuple> srcRightTuples) {
        if (srcRightTuples.getUpdateFirst() != null) {
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = (RightTuple)rightTuple.getStagedNext();
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }

    private static void insertLeft(BetaNode node, LeftTupleSink sink, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleMemory ltm, boolean tupleMemoryEnabled) {
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleList matches;
            boolean useTupleMemory;
            LeftTuple next = leftTuple.getStagedNext();
            boolean bl = useTupleMemory = tupleMemoryEnabled || RuleNetworkEvaluator.useLeftMemory(node, leftTuple);
            if (useTupleMemory) {
                ltm.add(leftTuple);
            }
            if (node.getType() == 191 && (matches = (TupleList)leftTuple.getContextObject()) == null && !leftTuple.isExpired()) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useTupleMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private static void insertRight(BetaNode node, LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, TupleSets<RightTuple> srcRightTuples, boolean tupleMemoryEnabled) {
        if (srcRightTuples.getInsertFirst() != null) {
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = (RightTuple)rightTuple.getStagedNext();
                LeftTuple leftTuple = node.getStartTuple((SubnetworkTuple)rightTuple);
                TupleList matches = (TupleList)leftTuple.getContextObject();
                if (matches == null) {
                    matches = new TupleList();
                    leftTuple.setContextObject(matches);
                }
                matches.add(rightTuple);
                if (matches.size() == 1) {
                    if (node.getType() == 201) {
                        if (!leftTuple.isExpired()) {
                            boolean useTupleMemory = tupleMemoryEnabled || RuleNetworkEvaluator.useLeftMemory(node, rightTuple);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useTupleMemory));
                        }
                    } else {
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }

    private static void deleteLeft(TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, TupleMemory ltm) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
                if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                    childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
                leftTuple.setContextObject(null);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }
}

