/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.rule.ContextEntry;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakSubnetworkNotExistsNode;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.FastIterator;

public class PhreakExistsNode {
    public void doNode(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        if (!existsNode.isRightInputIsRiaNode()) {
            this.doNormalNode(existsNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        } else {
            PhreakSubnetworkNotExistsNode.doSubNetworkNode(existsNode, sink, bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
    }

    public void doNormalNode(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesExistentialReorderLeftMemory(bm, srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesExistentialReorderRightMemory(bm, existsNode, srcRightTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(existsNode, sink, bm, reteEvaluator, srcRightTuples, trgLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(existsNode, sink, bm, reteEvaluator, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(existsNode, bm, reteEvaluator, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(existsNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(existsNode, sink, bm, reteEvaluator, srcLeftTuples, trgLeftTuples);
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(existsNode, leftTuple);
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            RuleNetworkEvaluator.findLeftTupleBlocker(existsNode, rtm, contextEntry, constraints, leftTuple, useLeftMemory);
            if (leftTuple.getBlocker() != null) {
                PhreakExistsNode.insertChildLeftTuple(sink, trgLeftTuples, leftTuple, leftTuple.getBlocker().getPropagationContext(), useLeftMemory);
            } else if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm != null && ltm.size() > 0) {
                FastIterator<Tuple> it = existsNode.getLeftIterator(ltm);
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                LeftTuple leftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        PhreakExistsNode.insertChildLeftTuple(sink, trgLeftTuples, leftTuple, rightTuple.getPropagationContext(), true);
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        boolean leftUpdateOptimizationAllowed = existsNode.isLeftUpdateOptimizationAllowed();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            FastIterator<Tuple> rightIt = existsNode.getRightIterator(rtm);
            RightTuple firstRightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, rightIt);
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
            } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                blocker.removeBlocked(leftTuple);
                blocker = null;
            }
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            if (!leftUpdateOptimizationAllowed && blocker != null) {
                blocker.removeBlocked(leftTuple);
                blocker = null;
            }
            if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandleForEvaluation())) {
                if (blocker != null) {
                    blocker.removeBlocked(leftTuple);
                }
                RightTuple newBlocker = firstRightTuple;
                while (newBlocker != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandleForEvaluation())) {
                        leftTuple.setBlocker(newBlocker);
                        newBlocker.addBlocked(leftTuple);
                        break;
                    }
                    newBlocker = (RightTuple)rightIt.next(newBlocker);
                }
            }
            if (leftTuple.getBlocker() == null) {
                ltm.add(leftTuple);
                if (leftTuple.getFirstChild() != null) {
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(leftTuple.getFirstChild(), trgLeftTuples, stagedLeftTuples);
                }
            } else if (leftTuple.getFirstChild() == null) {
                PhreakExistsNode.insertChildLeftTuple(sink, trgLeftTuples, leftTuple, leftTuple.getBlocker().getPropagationContext(), true);
            } else {
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getHandleNext()) {
                    childLeftTuple.setPropagationContext(leftTuple.getBlocker().getPropagationContext());
                    PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                    childLeftTuple.reAddRight();
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        boolean iterateFromStart = existsNode.isIndexedUnificationJoin() || rtm.getIndexType().isComparison();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            LeftTuple firstBlocked;
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                FastIterator<Tuple> leftIt = existsNode.getLeftIterator(ltm);
                LeftTuple firstLeftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        PhreakExistsNode.insertChildLeftTuple(sink, trgLeftTuples, leftTuple, rightTuple.getPropagationContext(), true);
                    }
                    leftTuple = temp;
                }
            }
            if ((firstBlocked = rightTuple.getTempBlocked()) != null) {
                RightTuple rootBlocker = rightTuple.getTempNextRightTuple();
                if (rootBlocker == null) {
                    iterateFromStart = true;
                }
                FastIterator<Tuple> rightIt = existsNode.getRightIterator(rtm);
                LeftTuple leftTuple = firstBlocked;
                while (leftTuple != null) {
                    LeftTuple temp = leftTuple.getBlockedNext();
                    leftTuple.clearBlocker();
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        leftTuple = temp;
                        continue;
                    }
                    constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
                    if (iterateFromStart) {
                        rootBlocker = existsNode.getFirstRightTuple(leftTuple, rtm, rightIt);
                    }
                    RightTuple newBlocker = rootBlocker;
                    while (newBlocker != null) {
                        if (leftTuple.getStagedType() != 3 && newBlocker.getStagedType() != 3 && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandleForEvaluation())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                    if (leftTuple.getBlocker() == null) {
                        LeftTuple childLeftTuple;
                        if (ltm != null) {
                            ltm.add(leftTuple);
                        }
                        if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftDeletes(BetaMemory bm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
            } else {
                if (leftTuple.getFirstChild() != null) {
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(leftTuple.getFirstChild(), trgLeftTuples, stagedLeftTuples);
                }
                blocker.removeBlocked(leftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(ExistsNode existsNode, BetaMemory bm, ReteEvaluator reteEvaluator, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory rtm = bm.getRightTupleMemory();
        TupleMemory ltm = bm.getLeftTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
            }
            if (rightTuple.getBlocked() != null) {
                FastIterator<Tuple> it = existsNode.getRightIterator(rtm);
                LeftTuple leftTuple = rightTuple.getBlocked();
                while (leftTuple != null) {
                    RightTuple rootBlocker;
                    LeftTuple temp = leftTuple.getBlockedNext();
                    leftTuple.clearBlocker();
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
                    RightTuple newBlocker = rootBlocker = (RightTuple)rtm.getFirst(leftTuple);
                    while (newBlocker != null) {
                        if (!newBlocker.isDeleted() && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandleForEvaluation())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)it.next(newBlocker);
                    }
                    if (leftTuple.getBlocker() == null) {
                        ltm.add(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.setBlocked(null);
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }

    private static void insertChildLeftTuple(LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, LeftTuple leftTuple, PropagationContext pctx, boolean useLeftMemory) {
        if (!leftTuple.isExpired()) {
            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, pctx, useLeftMemory));
        }
    }
}

