/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;

public class WorkingMemoryReteExpireAction
extends PropagationEntry.AbstractPropagationEntry
implements WorkingMemoryAction,
Externalizable {
    protected DefaultEventHandle factHandle;
    protected ObjectTypeNode node;

    public WorkingMemoryReteExpireAction() {
    }

    public WorkingMemoryReteExpireAction(DefaultEventHandle factHandle) {
        this.factHandle = factHandle;
    }

    public WorkingMemoryReteExpireAction(DefaultEventHandle factHandle, ObjectTypeNode node) {
        this(factHandle);
        this.node = node;
        factHandle.increaseOtnCount();
    }

    public DefaultEventHandle getFactHandle() {
        return this.factHandle;
    }

    public void setFactHandle(DefaultEventHandle factHandle) {
        this.factHandle = factHandle;
    }

    public ObjectTypeNode getNode() {
        return this.node;
    }

    public void setNode(ObjectTypeNode node) {
        this.node = node;
    }

    public WorkingMemoryReteExpireAction(MarshallerReaderContext context) throws IOException {
        this.factHandle = (DefaultEventHandle)context.getHandles().get(context.readLong());
        int nodeId = context.readInt();
        this.node = (ObjectTypeNode)context.getSinks().get(nodeId);
    }

    @Override
    public void internalExecute(ReteEvaluator reteEvaluator) {
        if (!this.factHandle.isValid()) {
            return;
        }
        PropagationContext context = PhreakPropagationContextFactory.createPropagationContextForFact(reteEvaluator, this.factHandle, PropagationContext.Type.EXPIRATION);
        reteEvaluator.getActivationsManager().registerExpiration(context);
        this.factHandle.forEachLeftTuple(ObjectTypeNode::expireLeftTuple);
        this.factHandle.forEachRightTuple(rt -> {
            rt.setExpired(reteEvaluator, context);
            ObjectTypeNode.expireRightTuple(rt);
        });
        WorkingMemoryReteExpireAction.expireFactHandle(this.factHandle);
    }

    private static void expireFactHandle(DefaultEventHandle factHandle) {
        factHandle.decreaseOtnCount();
        if (factHandle.getOtnCount() <= 0) {
            factHandle.setExpired(true);
            factHandle.setPendingRemoveFromStore(true);
        }
    }

    @Override
    public boolean isPartitionSplittable() {
        return true;
    }

    @Override
    public PropagationEntry getSplitForPartition(int partitionNr) {
        return new PartitionAwareWorkingMemoryReteExpireAction(this.factHandle, this.node, partitionNr);
    }

    public String toString() {
        return "Expiration of " + this.factHandle.getObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new DefaultEventHandle(this.factHandle.getId(), this.factHandle.getEntryPointId()));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factHandle = (DefaultEventHandle)in.readObject();
    }

    public static class PartitionAwareWorkingMemoryReteExpireAction
    extends PropagationEntry.AbstractPartitionedPropagationEntry {
        private final DefaultEventHandle factHandle;
        private final ObjectTypeNode node;

        public PartitionAwareWorkingMemoryReteExpireAction(DefaultEventHandle factHandle, ObjectTypeNode node, int partition) {
            super(partition);
            this.factHandle = factHandle;
            this.node = node;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            if (!this.factHandle.isValid()) {
                return;
            }
            PropagationContext context = PhreakPropagationContextFactory.createPropagationContextForFact(reteEvaluator, this.factHandle, PropagationContext.Type.EXPIRATION);
            reteEvaluator.getActivationsManager().getPartitionedAgenda(this.partition).registerExpiration(context);
            DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)this.factHandle.getLinkedTuples();
            linkedTuples.forEachLeftTuple(this.partition, ObjectTypeNode::expireLeftTuple);
            linkedTuples.forEachRightTuple(this.partition, rt -> {
                rt.setExpired(reteEvaluator, context);
                ObjectTypeNode.expireRightTuple(rt);
            });
            if (this.isMainPartition()) {
                WorkingMemoryReteExpireAction.expireFactHandle(this.factHandle);
            }
        }

        public String toString() {
            return "Expiration of " + this.factHandle.getObject() + " for partition " + this.partition;
        }
    }
}

