/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.DefaultEventHandle;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.WindowTuple;

public class WindowTupleList {
    protected DefaultEventHandle handle;
    private WindowTupleList listPrevious;
    private WindowTupleList listNext;
    public WindowTuple firstWindowTuple;
    public WindowTuple lastWindowTuple;
    private WindowNode node;

    public WindowTupleList() {
    }

    public WindowTupleList(DefaultEventHandle handle, WindowNode node) {
        this.handle = handle;
        this.node = node;
    }

    public WindowNode getWindowNode() {
        return this.node;
    }

    public void unlinkFromHandle() {
        this.handle = null;
        this.listPrevious = null;
        this.listNext = null;
    }

    public DefaultEventHandle getHandle() {
        return this.handle;
    }

    public WindowTupleList getListPrevious() {
        return this.listPrevious;
    }

    public void setListPrevious(WindowTupleList listPrevious) {
        this.listPrevious = listPrevious;
    }

    public WindowTupleList getListNext() {
        return this.listNext;
    }

    public void setListNext(WindowTupleList listNext) {
        this.listNext = listNext;
    }

    public void addFirstWindowTuple(WindowTuple windowTuple) {
        WindowTuple previousFirst = this.firstWindowTuple;
        this.firstWindowTuple = windowTuple;
        if (previousFirst == null) {
            windowTuple.setWindowPrevious(null);
            windowTuple.setWindowNext(null);
            this.lastWindowTuple = windowTuple;
        } else {
            windowTuple.setWindowPrevious(null);
            windowTuple.setWindowNext(previousFirst);
            previousFirst.setWindowPrevious(windowTuple);
        }
    }

    public void addLastWindowTuple(WindowTuple windowTuple) {
        WindowTuple previousLast = this.lastWindowTuple;
        this.lastWindowTuple = windowTuple;
        if (previousLast == null) {
            windowTuple.setWindowPrevious(null);
            windowTuple.setWindowNext(null);
            this.firstWindowTuple = windowTuple;
        } else {
            windowTuple.setWindowPrevious(previousLast);
            windowTuple.setWindowNext(null);
            previousLast.setWindowNext(windowTuple);
        }
    }

    public void removeWindowTuple(WindowTuple windowTuple) {
        WindowTuple previous = windowTuple.getWindowPrevious();
        WindowTuple next = windowTuple.getWindowNext();
        if (previous != null && next != null) {
            previous.setWindowNext(next);
            next.setWindowPrevious(previous);
        } else if (next != null) {
            next.setWindowPrevious(null);
            this.firstWindowTuple = next;
        } else if (previous != null) {
            previous.setWindowNext(null);
            this.lastWindowTuple = previous;
        } else {
            this.firstWindowTuple = null;
            this.lastWindowTuple = null;
        }
        windowTuple.setWindowPrevious(null);
        windowTuple.setWindowNext(null);
    }

    public WindowTuple getFirstWindowTuple() {
        return this.firstWindowTuple;
    }

    public WindowTuple getLastWindowTuple() {
        return this.lastWindowTuple;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return this.handle.toString() + "\n";
    }

    public boolean equals(WindowTupleList other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.handle == other.handle;
    }

    public boolean equals(Object object) {
        return this.equals((WindowTupleList)object);
    }
}

