/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourceHelper {
    public static Collection<File> getFileResourcesByExtension(String extension) {
        return Arrays.stream(ResourceHelper.getClassPathElements()).flatMap(elem -> ResourceHelper.internalGetFileResources(elem, Pattern.compile(".*\\." + extension + "$")).stream()).collect(Collectors.toSet());
    }

    public static Collection<String> getResourcesByExtension(String extension) {
        return Arrays.stream(ResourceHelper.getClassPathElements()).flatMap(elem -> ResourceHelper.internalGetResources(elem, Pattern.compile(".*\\." + extension + "$")).stream()).collect(Collectors.toSet());
    }

    public static Collection<File> getFileResourcesFromDirectory(File directory, Pattern pattern) {
        if (directory == null || directory.listFiles() == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(Objects.requireNonNull(directory.listFiles())).flatMap(elem -> {
            if (elem.isDirectory()) {
                return ResourceHelper.getFileResourcesFromDirectory(elem, pattern).stream();
            }
            try {
                if (pattern.matcher(elem.getCanonicalPath()).matches()) {
                    return Stream.of(elem);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to retrieve resources from directory " + directory.getAbsolutePath() + " with pattern " + pattern.pattern(), e);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
    }

    public static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        if (directory == null || directory.listFiles() == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(Objects.requireNonNull(directory.listFiles())).flatMap(elem -> {
            if (elem.isDirectory()) {
                return ResourceHelper.getResourcesFromDirectory(elem, pattern).stream();
            }
            try {
                String fileName = elem.getCanonicalPath();
                if (pattern.matcher(fileName).matches()) {
                    return Stream.of(fileName);
                }
                return Stream.empty();
            }
            catch (IOException e) {
                throw new RuntimeException("Impossible to access to resources", e);
            }
        }).collect(Collectors.toSet());
    }

    static String[] getClassPathElements() {
        return System.getProperty("java.class.path", ".").split(System.getProperty("path.separator"));
    }

    static Collection<File> internalGetFileResources(String path, Pattern pattern) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return Collections.emptySet();
        }
        return ResourceHelper.getFileResourcesFromDirectory(file, pattern);
    }

    static Collection<String> internalGetResources(String path, Pattern pattern) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return Collections.emptySet();
        }
        return ResourceHelper.getResourcesFromDirectory(file, pattern);
    }

    private ResourceHelper() {
    }
}

