/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public class PortablePath
implements Serializable {
    private static final boolean IS_WINDOWS_SEPARATOR = File.separatorChar == '\\';
    public static final PortablePath ROOT_PATH = new PortablePath("");
    private String path;

    public PortablePath() {
    }

    private PortablePath(String path) {
        this.path = path;
    }

    public static PortablePath of(String s) {
        return PortablePath.of(s, IS_WINDOWS_SEPARATOR);
    }

    static PortablePath of(String s, boolean isWindowsSeparator) {
        String normalized = PortablePath.normalizePath(s, isWindowsSeparator);
        return normalized.isEmpty() ? ROOT_PATH : new PortablePath(normalized);
    }

    private static String normalizePath(String s, boolean isWindowsSeparator) {
        if (s == null) {
            throw new NullPointerException("A path cannot be null");
        }
        return PortablePath.trimTrailingSeparator(isWindowsSeparator ? s.replace('\\', '/') : s);
    }

    public PortablePath getParent() {
        int lastSlash = this.path.lastIndexOf(47);
        return lastSlash >= 0 ? new PortablePath(this.path.substring(0, lastSlash)) : ROOT_PATH;
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public PortablePath resolve(PortablePath portablePath) {
        return this.isEmpty() ? portablePath : new PortablePath(this.path + "/" + portablePath.asString());
    }

    public PortablePath resolve(String name) {
        return this.resolve(PortablePath.of(name));
    }

    public String getFileName() {
        int lastSlash = this.path.lastIndexOf(47);
        return lastSlash >= 0 ? this.path.substring(lastSlash + 1) : this.path;
    }

    public String asString() {
        return this.path;
    }

    public String asClassName() {
        return this.path.substring(0, this.path.length() - ".class".length()).replace('/', '.');
    }

    public String toString() {
        return "KiePath{path='" + this.path + "'}";
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortablePath)) {
            return false;
        }
        PortablePath portablePath = (PortablePath)o;
        return Objects.equals(this.path, portablePath.path);
    }

    public boolean endsWith(String s) {
        return this.path.endsWith(s);
    }

    public boolean startsWith(String s) {
        return this.path.startsWith(s);
    }

    public PortablePath substring(int beginIndex) {
        return PortablePath.of(this.path.substring(beginIndex));
    }

    public PortablePath substring(int beginIndex, int endIndex) {
        return PortablePath.of(this.path.substring(beginIndex, endIndex));
    }

    public static String trimTrailingSeparator(String p) {
        return !p.isEmpty() && p.charAt(p.length() - 1) == '/' ? p.substring(0, p.length() - 1) : p;
    }
}

