/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drlonyaml.model.AbstractThen;
import org.drools.drlonyaml.model.Base;
import org.drools.drlonyaml.model.StringThen;
import org.drools.drlonyaml.model.Utils;

@JsonPropertyOrder(value={"name", "when", "then"})
public class Rule {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(required=true)
    private List<Base> when = new ArrayList<Base>();
    @JsonProperty(required=true)
    private AbstractThen then;

    public static Rule from(RuleDescr r) {
        Objects.requireNonNull(r);
        Rule result = new Rule();
        result.name = r.getName();
        for (BaseDescr dd : r.getLhs().getDescrs()) {
            result.when.add(Utils.from(dd));
        }
        result.then = StringThen.from(r.getConsequence().toString());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<Base> getWhen() {
        return this.when;
    }

    public Object getThen() {
        return this.then;
    }
}

