/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ConditionalElement;
import org.drools.base.rule.Declaration;
import org.drools.base.time.JobHandle;
import org.drools.base.time.Trigger;
import org.drools.base.time.impl.Timer;
import org.drools.core.time.TimerExpression;
import org.drools.core.time.TimerExpressionUtil;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.IntervalTrigger;
import org.kie.api.runtime.Calendars;

public class ExpressionIntervalTimer
extends BaseTimer
implements Timer,
Externalizable {
    private TimerExpression startTime;
    private TimerExpression endTime;
    private int repeatLimit;
    private TimerExpression delay;
    private TimerExpression period;

    public ExpressionIntervalTimer() {
    }

    public ExpressionIntervalTimer(TimerExpression startTime, TimerExpression endTime, int repeatLimit, TimerExpression delay, TimerExpression period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.delay);
        out.writeObject(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (TimerExpression)in.readObject();
        this.endTime = (TimerExpression)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = (TimerExpression)in.readObject();
        this.period = (TimerExpression)in.readObject();
    }

    public Declaration[] getStartDeclarations() {
        return this.startTime != null ? this.startTime.getDeclarations() : null;
    }

    public Declaration[] getEndDeclarations() {
        return this.endTime != null ? this.endTime.getDeclarations() : null;
    }

    public Declaration[] getDelayDeclarations() {
        return this.delay.getDeclarations();
    }

    public Declaration[] getPeriodDeclarations() {
        return this.period.getDeclarations();
    }

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return new Declaration[][]{this.sortDeclarations(outerDeclrs, this.getDelayDeclarations()), this.sortDeclarations(outerDeclrs, this.getPeriodDeclarations()), this.sortDeclarations(outerDeclrs, this.getStartDeclarations()), this.sortDeclarations(outerDeclrs, this.getEndDeclarations())};
    }

    @Override
    public Trigger createTrigger(long timestamp, BaseTuple leftTuple, JobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, ValueResolver valueResolver) {
        long newDelay;
        long timeSinceLastFire = 0L;
        Declaration[] delayDeclarations = declrs[0];
        Declaration[] periodDeclarations = declrs[1];
        Declaration[] startDeclarations = declrs[2];
        Declaration[] endDeclarations = declrs[3];
        Date lastFireTime = null;
        Date createdTime = null;
        if (jh != null) {
            IntervalTrigger preTrig = (IntervalTrigger)((DefaultJobHandle)jh).getTimerJobInstance().getTrigger();
            lastFireTime = preTrig.getLastFireTime();
            createdTime = preTrig.getCreatedTime();
            newDelay = lastFireTime != null ? TimerExpressionUtil.evalTimeExpression(this.period, leftTuple, delayDeclarations, valueResolver) - timestamp + lastFireTime.getTime() : TimerExpressionUtil.evalTimeExpression(this.delay, leftTuple, delayDeclarations, valueResolver) - timestamp + createdTime.getTime();
        } else {
            newDelay = TimerExpressionUtil.evalTimeExpression(this.delay, leftTuple, delayDeclarations, valueResolver);
        }
        if (newDelay < 0L) {
            newDelay = 0L;
        }
        return new IntervalTrigger(timestamp, TimerExpressionUtil.evalDateExpression(this.startTime, leftTuple, startDeclarations, valueResolver), TimerExpressionUtil.evalDateExpression(this.endTime, leftTuple, startDeclarations, valueResolver), this.repeatLimit, newDelay, this.period != null ? TimerExpressionUtil.evalTimeExpression(this.period, leftTuple, periodDeclarations, valueResolver) : 0L, calendarNames, calendars, createdTime, lastFireTime);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, null, null, this.repeatLimit, 0L, 0L, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delay.hashCode();
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + this.period.hashCode();
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionIntervalTimer other = (ExpressionIntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new ExpressionIntervalTimer(this.startTime, this.endTime, this.repeatLimit, this.delay, this.period);
    }
}

