/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.base.common.RuleBasePartitionId;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;

public class ModifyPreviousTuples {
    private final InternalFactHandle.LinkedTuples linkedTuples;

    public ModifyPreviousTuples(InternalFactHandle.LinkedTuples linkedTuples) {
        this.linkedTuples = linkedTuples;
    }

    public LeftTuple peekLeftTuple(int partition) {
        return this.linkedTuples.getFirstLeftTuple(partition);
    }

    public LeftTuple peekLeftTuple(RuleBasePartitionId partitionId) {
        return this.linkedTuples.getFirstLeftTuple(partitionId);
    }

    public RightTuple peekRightTuple(int partition) {
        return this.linkedTuples.getFirstRightTuple(partition);
    }

    public RightTuple peekRightTuple(RuleBasePartitionId partitionId) {
        return this.linkedTuples.getFirstRightTuple(partitionId);
    }

    public void removeLeftTuple(int partition) {
        this.linkedTuples.removeLeftTuple(this.peekLeftTuple(partition));
    }

    public void removeLeftTuple(RuleBasePartitionId partitionId) {
        this.linkedTuples.removeLeftTuple(this.peekLeftTuple(partitionId));
    }

    public void removeRightTuple(int partition) {
        this.linkedTuples.removeRightTuple(this.peekRightTuple(partition));
    }

    public void removeRightTuple(RuleBasePartitionId partitionId) {
        this.linkedTuples.removeRightTuple(this.peekRightTuple(partitionId));
    }

    public void retractTuples(PropagationContext pctx, ReteEvaluator reteEvaluator) {
        this.linkedTuples.forEachLeftTuple(lt -> this.doDeleteObject(pctx, reteEvaluator, (LeftTuple)lt));
        this.linkedTuples.forEachRightTuple(rt -> this.doRightDelete(pctx, reteEvaluator, (RightTuple)rt));
    }

    public void doDeleteObject(PropagationContext pctx, ReteEvaluator reteEvaluator, LeftTuple leftTuple) {
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)leftTuple.getTupleSource();
        LeftInputAdapterNode.LiaNodeMemory lm = reteEvaluator.getNodeMemory(liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        if (sm != null) {
            LeftInputAdapterNode.doDeleteObject(leftTuple, pctx, sm, reteEvaluator, liaNode, true, lm);
        } else {
            ActivationsManager activationsManager = reteEvaluator.getActivationsManager();
            TerminalNode rtn = (TerminalNode)leftTuple.getTupleSink();
            PathMemory pathMemory = reteEvaluator.getNodeMemory(rtn);
            PhreakRuleTerminalNode.doLeftDelete(activationsManager, pathMemory.getRuleAgendaItem().getRuleExecutor(), leftTuple);
        }
    }

    public void doRightDelete(PropagationContext pctx, ReteEvaluator reteEvaluator, RightTuple rightTuple) {
        rightTuple.setPropagationContext(pctx);
        rightTuple.retractTuple(pctx, reteEvaluator);
    }
}

