/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Collection;
import java.util.List;
import org.drools.base.RuleBase;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.Pattern;
import org.drools.core.common.BaseNode;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;

public abstract class LeftTupleSource
extends BaseNode
implements LeftTupleNode {
    protected BitMask leftDeclaredMask = EmptyBitMask.get();
    protected BitMask leftInferredMask = EmptyBitMask.get();
    protected BitMask leftNegativeMask = EmptyBitMask.get();
    protected LeftTupleSource leftInput;
    protected LeftTupleSinkPropagator sink;
    private transient ObjectTypeNode.Id leftInputOtnId;
    private int pathIndex;
    private int objectCount;

    public LeftTupleSource() {
    }

    protected LeftTupleSource(int id, BuildContext context) {
        super(id, context != null ? context.getPartitionId() : RuleBasePartitionId.MAIN_PARTITION, context != null && context.getRuleBase().getRuleBaseConfiguration().isMultithreadEvaluation());
        this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        this.initMemoryId(context);
    }

    @Override
    public int getPathIndex() {
        return this.pathIndex;
    }

    @Override
    public abstract short getType();

    public abstract LeftTuple createPeer(LeftTuple var1);

    public void addTupleSink(LeftTupleSink tupleSink) {
        this.addTupleSink(tupleSink, null);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    public final void setLeftTupleSource(LeftTupleSource leftInput) {
        this.leftInput = leftInput;
        this.pathIndex = leftInput.getPathIndex() + 1;
    }

    @Override
    public int getObjectCount() {
        return this.objectCount;
    }

    @Override
    public void setObjectCount(int count) {
        this.objectCount = count;
    }

    public void addTupleSink(LeftTupleSink tupleSink, BuildContext context) {
        this.sink = this.addTupleSink(this.sink, tupleSink, context);
    }

    protected LeftTupleSinkPropagator addTupleSink(LeftTupleSinkPropagator sinkPropagator, LeftTupleSink tupleSink, BuildContext context) {
        if (sinkPropagator instanceof EmptyLeftTupleSinkAdapter) {
            return new SingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink);
        }
        if (sinkPropagator instanceof SingleLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter sinkAdapter = new CompositeLeftTupleSinkAdapter(this.getPartitionId());
            sinkAdapter.addTupleSink(sinkPropagator.getSinks()[0]);
            sinkAdapter.addTupleSink(tupleSink);
            return sinkAdapter;
        }
        ((CompositeLeftTupleSinkAdapter)sinkPropagator).addTupleSink(tupleSink);
        return sinkPropagator;
    }

    public void removeTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        } else {
            CompositeLeftTupleSinkAdapter sinkAdapter = (CompositeLeftTupleSinkAdapter)this.sink;
            sinkAdapter.removeTupleSink(tupleSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public LeftTupleSinkNode getFirstLeftTupleSinkIgnoreRemoving(TerminalNode removingTn) {
        if (removingTn == null) {
            return this.sink.getFirstLeftTupleSink();
        }
        for (LeftTupleSink sink : this.sink.getSinks()) {
            if (!BuildtimeSegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(removingTn, sink)) continue;
            return (LeftTupleSinkNode)sink;
        }
        throw new RuntimeException("This should always return a sink");
    }

    @Override
    public LeftTupleSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public void setSourcePartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        this.setSourcePartitionId(this.leftInput, context, partitionId);
    }

    protected void setSourcePartitionId(BaseNode source, BuildContext context, RuleBasePartitionId partitionId) {
        if (this.partitionId == partitionId) {
            return;
        }
        this.partitionId = partitionId;
        if (source.getPartitionId() == RuleBasePartitionId.MAIN_PARTITION) {
            this.setPartitionIdWithSinks(partitionId);
        } else {
            source.setPartitionId(context, partitionId);
        }
    }

    public final void setPartitionIdWithSinks(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
        for (LeftTupleSink sink : this.getSinkPropagator().getSinks()) {
            sink.setPartitionIdWithSinks(partitionId);
        }
    }

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    protected final void initMasks(BuildContext context, LeftTupleSource leftInput) {
        this.initDeclaredMask(context, leftInput);
        this.initInferredMask(leftInput);
    }

    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.leftDeclaredMask = AllSetBitMask.get();
            return;
        }
        if (leftInput.getType() != 120) {
            this.leftDeclaredMask = AllSetBitMask.get();
            return;
        }
        Pattern pattern = this.getLeftInputPattern(context);
        ObjectType objectType = this.getObjectTypeForPropertyReactivity((LeftInputAdapterNode)leftInput, pattern);
        if (!(objectType instanceof ClassObjectType)) {
            this.leftDeclaredMask = AllSetBitMask.get();
            return;
        }
        if (pattern != null && PropertySpecificUtil.isPropertyReactive(context.getRuleBase(), objectType)) {
            Collection<String> leftListenedProperties = pattern.getListenedProperties();
            List<String> accessibleProperties = PropertySpecificUtil.getAccessibleProperties((RuleBase)context.getRuleBase(), objectType);
            this.leftDeclaredMask = PropertySpecificUtil.calculatePositiveMask(objectType, leftListenedProperties, accessibleProperties);
            this.leftDeclaredMask = this.setNodeConstraintsPropertyReactiveMask(this.leftDeclaredMask, objectType, accessibleProperties);
            this.leftNegativeMask = PropertySpecificUtil.calculateNegativeMask(objectType, leftListenedProperties, accessibleProperties);
            this.setLeftListenedProperties(leftListenedProperties);
        } else {
            this.leftDeclaredMask = AllSetBitMask.get();
        }
    }

    protected BitMask setNodeConstraintsPropertyReactiveMask(BitMask mask, ObjectType objectType, List<String> accessibleProperties) {
        return mask;
    }

    protected Pattern getLeftInputPattern(BuildContext context) {
        return context.getLastBuiltPatterns()[1];
    }

    protected ObjectType getObjectTypeForPropertyReactivity(LeftInputAdapterNode leftInput, Pattern pattern) {
        return pattern != null ? pattern.getObjectType() : leftInput.getParentObjectSource().getObjectTypeNode().getObjectType();
    }

    protected void setLeftListenedProperties(Collection<String> leftListenedProperties) {
    }

    protected void initInferredMask(LeftTupleSource leftInput) {
        LeftTupleSource unwrappedLeft = this.unwrapLeftInput(leftInput);
        if (unwrappedLeft.getType() == 120 && ((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource().getType() == 40) {
            ObjectSource objectSource = ((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource();
            this.leftInferredMask = objectSource.updateMask(this.leftDeclaredMask);
        } else {
            this.leftInferredMask = this.leftDeclaredMask;
        }
        this.leftInferredMask = this.leftInferredMask.resetAll(this.leftNegativeMask);
    }

    private LeftTupleSource unwrapLeftInput(LeftTupleSource leftInput) {
        if (leftInput.getType() == 151 || leftInput.getType() == 153) {
            return leftInput.getLeftTupleSource();
        }
        return leftInput;
    }

    public BitMask getLeftDeclaredMask() {
        return this.leftDeclaredMask;
    }

    public BitMask getLeftInferredMask() {
        return this.leftInferredMask;
    }

    protected void setLeftInferredMask(BitMask leftInferredMask) {
        this.leftInferredMask = leftInferredMask;
    }

    public BitMask getLeftNegativeMask() {
        return this.leftNegativeMask;
    }

    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    public ObjectType getObjectType() {
        ObjectTypeNode objectTypeNode = this.getObjectTypeNode();
        return objectTypeNode != null ? objectTypeNode.getObjectType() : null;
    }

    public abstract boolean isLeftTupleMemoryEnabled();
}

