/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.rule.accessor.GlobalResolver;
import org.kie.api.runtime.Globals;

public class MapGlobalResolver
implements GlobalResolver,
Globals,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<String, Object> map;
    private Globals delegate;

    public MapGlobalResolver() {
        this(new ConcurrentHashMap<String, Object>());
    }

    public MapGlobalResolver(Map<String, Object> map) {
        if (map instanceof ConcurrentHashMap) {
            this.map = map;
        } else {
            this.map = new ConcurrentHashMap<String, Object>();
            this.map.putAll(map);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.map = (Map)in.readObject();
        this.delegate = (Globals)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.map);
        out.writeObject(this.delegate);
    }

    @Override
    public void setDelegate(Globals delegate) {
        this.delegate = delegate;
    }

    @Override
    public Collection<String> getGlobalKeys() {
        if (this.delegate == null) {
            return Collections.unmodifiableCollection(this.map.keySet());
        }
        if (this.map.isEmpty()) {
            return Collections.unmodifiableCollection(((MapGlobalResolver)this.delegate).map.keySet());
        }
        HashSet<String> combined = new HashSet<String>(this.map.keySet());
        combined.addAll(((MapGlobalResolver)this.delegate).map.keySet());
        return Collections.unmodifiableCollection(combined);
    }

    @Override
    public Object get(String identifier) {
        return this.resolveGlobal(identifier);
    }

    @Override
    public Object resolveGlobal(String identifier) {
        Object object = this.map.get(identifier);
        if (object == null && this.delegate != null) {
            object = this.delegate.get(identifier);
        }
        return object;
    }

    @Override
    public void set(String identifier, Object value) {
        this.setGlobal(identifier, value);
    }

    @Override
    public void setGlobal(String identifier, Object value) {
        if (value == null) {
            this.map.remove(identifier);
        } else {
            this.map.put(identifier, value);
        }
    }

    @Override
    public void removeGlobal(String identifier) {
        this.map.remove(identifier);
    }

    public Map.Entry<String, Object>[] getGlobals() {
        if (this.delegate == null) {
            return this.map.entrySet().toArray(new Map.Entry[this.map.size()]);
        }
        if (this.map.isEmpty()) {
            Map<String, Object> delegateMap = ((MapGlobalResolver)this.delegate).map;
            return delegateMap.entrySet().toArray(new Map.Entry[delegateMap.size()]);
        }
        HashMap<String, Object> combined = new HashMap<String, Object>(((MapGlobalResolver)this.delegate).map);
        combined.putAll(this.map);
        return combined.entrySet().toArray(new Map.Entry[combined.size()]);
    }

    public GlobalResolver clone() {
        HashMap<String, Object> clone = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.getGlobals()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return new MapGlobalResolver(clone);
    }

    public String toString() {
        return "MapGlobalResolver [map=" + this.map + ", delegate=" + this.delegate + "]";
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

