/*
 * Decompiled with CFR 0.152.
 */
package org.drools.wiring.statics;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.ProtectionDomain;
import org.drools.wiring.api.ComponentsSupplier;
import org.drools.wiring.api.ResourceProvider;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.drools.wiring.api.util.ByteArrayClassLoader;
import org.drools.wiring.statics.StaticProjectClassLoader;
import org.kie.api.runtime.rule.ConsequenceException;
import org.kie.api.runtime.rule.ConsequenceExceptionHandler;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;

public class StaticComponentsSupplier
implements ComponentsSupplier {
    @Override
    public ProjectClassLoader createProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        return StaticProjectClassLoader.create(parent, resourceProvider);
    }

    @Override
    public ByteArrayClassLoader createByteArrayClassLoader(ClassLoader parent) {
        return new DummyByteArrayClassLoader();
    }

    @Override
    public Object createConsequenceExceptionHandler(String className, ClassLoader classLoader) {
        return new StaticConsequenceExceptionHandler();
    }

    public static class StaticConsequenceExceptionHandler
    implements ConsequenceExceptionHandler,
    Externalizable {
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void handleException(Match activation, RuleRuntime workingMemory, Exception exception) {
            throw new ConsequenceException(exception, workingMemory, activation);
        }
    }

    public static class DummyByteArrayClassLoader
    implements ByteArrayClassLoader {
        @Override
        public Class<?> defineClass(String name, byte[] bytes, ProtectionDomain domain) {
            throw new UnsupportedOperationException("The artifact org.drools:drools-wiring-static does not support this operation, try using org.drools:drools-wiring-dynamic instead.");
        }
    }
}

