/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.BaseConfiguration;
import org.drools.core.util.ConfFileUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.MultiValueKieBaseOption;
import org.kie.api.conf.OptionKey;
import org.kie.api.conf.SingleValueKieBaseOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowBaseConfiguration
extends BaseConfiguration<KieBaseOption, SingleValueKieBaseOption, MultiValueKieBaseOption>
implements KieBaseConfiguration,
Externalizable {
    public static final ConfigurationKey<FlowBaseConfiguration> KEY = new ConfigurationKey("Rule");
    private static final long serialVersionUID = 510L;
    protected static final Logger logger = LoggerFactory.getLogger(FlowBaseConfiguration.class);
    private List<Map<String, Object>> workDefinitions;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public FlowBaseConfiguration(CompositeConfiguration<KieBaseOption, SingleValueKieBaseOption, MultiValueKieBaseOption> compConfig) {
        super(compConfig);
        this.initWorkDefinitions();
    }

    public List<Map<String, Object>> getWorkDefinitions() {
        if (this.workDefinitions == null) {
            this.initWorkDefinitions();
        }
        return this.workDefinitions;
    }

    private void initWorkDefinitions() {
        String[] locations;
        this.workDefinitions = new ArrayList<Map<String, Object>>();
        for (String factoryLocation : locations = this.getPropertyValue("drools.workDefinitions", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItems(factoryLocation);
        }
    }

    private void loadWorkItems(String location) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, FlowBaseConfiguration.class));
    }

    @Override
    public boolean setInternalProperty(String name, String value) {
        return false;
    }

    @Override
    public String getInternalProperty(String name) {
        return null;
    }

    @Override
    public <T extends SingleValueKieBaseOption> T getOption(OptionKey<T> option) {
        return (T)((SingleValueKieBaseOption)this.compConfig.getOption(option));
    }

    @Override
    public void setOption(KieBaseOption option) {
    }
}

