/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.lang.dsl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.drl.parser.lang.dsl.DSLMapping;
import org.drools.drl.parser.lang.dsl.DSLMappingEntry;
import org.drools.drl.parser.lang.dsl.DefaultDSLMapping;
import org.kie.internal.builder.KnowledgeBuilderResult;

public abstract class DSLMappingFile {
    private DSLMapping mapping = new DefaultDSLMapping();
    private List errors = Collections.emptyList();

    public DSLMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(DSLMapping mapping) {
        this.mapping = mapping;
    }

    public List<KnowledgeBuilderResult> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected void setErrors(List<? extends KnowledgeBuilderResult> errors) {
        this.errors = errors;
    }

    public abstract boolean parseAndLoad(Reader var1) throws IOException;

    public void saveMapping(Writer out) throws IOException {
        Iterator<DSLMappingEntry> it = this.mapping.getEntries().iterator();
        while (it.hasNext()) {
            out.write(it.next().toString());
            out.write("\n");
        }
    }

    public static void saveMapping(Writer out, DSLMapping mapping) throws IOException {
        for (DSLMappingEntry dslMappingEntry : mapping.getEntries()) {
            out.write(dslMappingEntry.toString());
            out.write("\n");
        }
    }

    public String dumpFile() {
        StringBuilder buf = new StringBuilder();
        for (DSLMappingEntry dslMappingEntry : this.mapping.getEntries()) {
            buf.append(dslMappingEntry);
            buf.append("\n");
        }
        return buf.toString();
    }
}

