/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.accessor.FactHandleFactory;

public abstract class AbstractFactHandleFactory
implements FactHandleFactory {
    private IdsGenerator idGen;
    private AtomicLong counter;

    public AbstractFactHandleFactory() {
        this.idGen = new IdsGenerator(0L);
        this.counter = new AtomicLong(0L);
    }

    public AbstractFactHandleFactory(long id, long counter) {
        this.idGen = new IdsGenerator(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public final InternalFactHandle newFactHandle(Object object, ObjectTypeConf conf, ReteEvaluator reteEvaluator, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(this.getNextId(), object, conf, reteEvaluator, wmEntryPoint);
    }

    public final InternalFactHandle newFactHandle(long id, Object object, ObjectTypeConf conf, ReteEvaluator reteEvaluator, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(id, object, this.getNextRecency(), conf, reteEvaluator, wmEntryPoint);
    }

    @Override
    public final InternalFactHandle newFactHandle(long id, Object object, long recency, ObjectTypeConf conf, ReteEvaluator reteEvaluator, WorkingMemoryEntryPoint wmEntryPoint) {
        WorkingMemoryEntryPoint entryPoint = this.getWmEntryPoint(reteEvaluator, wmEntryPoint);
        return conf == null ? this.createDefaultFactHandle(id, object, recency, entryPoint) : conf.createFactHandle(this, id, object, recency, reteEvaluator, entryPoint);
    }

    @Override
    public DefaultFactHandle createDefaultFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint entryPoint) {
        return new DefaultFactHandle(id, object, recency, entryPoint);
    }

    @Override
    public DefaultEventHandle createEventFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint entryPoint, long timestamp, long duration) {
        return new DefaultEventHandle(id, object, recency, timestamp, duration, entryPoint);
    }

    protected WorkingMemoryEntryPoint getWmEntryPoint(ReteEvaluator reteEvaluator, WorkingMemoryEntryPoint wmEntryPoint) {
        if (wmEntryPoint != null) {
            return wmEntryPoint;
        }
        return reteEvaluator != null ? reteEvaluator.getDefaultEntryPoint() : null;
    }

    @Override
    public final void increaseFactHandleRecency(InternalFactHandle factHandle) {
        factHandle.setRecency(this.getNextRecency());
    }

    @Override
    public void destroyFactHandle(InternalFactHandle factHandle) {
        factHandle.invalidate();
    }

    @Override
    public abstract FactHandleFactory newInstance();

    @Override
    public long getNextId() {
        return this.idGen.getNextId();
    }

    @Override
    public long getNextRecency() {
        return this.counter.incrementAndGet();
    }

    @Override
    public long getId() {
        return this.idGen.getId();
    }

    @Override
    public long getRecency() {
        return this.counter.get();
    }

    @Override
    public void clear(long id, long counter) {
        this.idGen = new IdsGenerator(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public void doRecycleIds(Collection<Long> usedIds) {
        this.idGen.doRecycle(usedIds);
    }

    @Override
    public void stopRecycleIds() {
        this.idGen.stopRecycle();
    }

    private static class IdsGenerator {
        private AtomicLong id;
        private Queue<Long> usedIds;
        private long recycledId;

        private IdsGenerator(long startId) {
            this.id = new AtomicLong(startId);
        }

        public long getNextId() {
            long l;
            if (this.hasRecycledId()) {
                long l2 = this.recycledId;
                l = l2;
                this.recycledId = l2 + 1L;
            } else {
                l = this.id.incrementAndGet();
            }
            return l;
        }

        private boolean hasRecycledId() {
            if (this.usedIds != null) {
                while (!this.usedIds.isEmpty()) {
                    long firstUsedId = this.usedIds.peek();
                    if (this.recycledId < firstUsedId) {
                        return true;
                    }
                    if (this.recycledId == firstUsedId) {
                        ++this.recycledId;
                    }
                    this.usedIds.poll();
                }
                this.usedIds = null;
            }
            return false;
        }

        public long getId() {
            return this.id.get();
        }

        public void doRecycle(Collection<Long> usedIds) {
            this.usedIds = usedIds.stream().sorted().collect(Collectors.toCollection(ArrayDeque::new));
            this.usedIds.add(this.id.get() + 1L);
            this.recycledId = 1L;
        }

        public void stopRecycle() {
            this.usedIds = null;
        }
    }
}

