/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.List;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.core.base.DroolsQueryImpl;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.util.LinkedList;

public class PhreakQueryTerminalNode {
    public void doNode(QueryTerminalNode qtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(qtnNode, activationsManager, srcLeftTuples, stack);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(qtnNode, activationsManager, srcLeftTuples, stack);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(qtnNode, activationsManager, srcLeftTuples, stack);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(QueryTerminalNode qtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            Tuple rootEntry = leftTuple.getRootTuple();
            DroolsQueryImpl dquery = (DroolsQueryImpl)rootEntry.getFactHandle().getObject();
            dquery.setQuery(qtnNode.getQuery());
            if (dquery.getStackEntry() != null) {
                PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(activationsManager, stack, rootEntry, dquery);
            }
            dquery.getQueryResultCollector().rowAdded((RuleImpl)qtnNode.getQuery(), leftTuple, activationsManager.getReteEvaluator());
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(QueryTerminalNode qtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple rootEntry = (LeftTuple)leftTuple.getRootTuple();
            DroolsQueryImpl dquery = (DroolsQueryImpl)rootEntry.getFactHandle().getObject();
            dquery.setQuery(qtnNode.getQuery());
            if (dquery.getStackEntry() != null) {
                PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(activationsManager, stack, rootEntry, dquery);
            }
            dquery.getQueryResultCollector().rowUpdated((RuleImpl)qtnNode.getQuery(), leftTuple, activationsManager.getReteEvaluator());
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(QueryTerminalNode qtnNode, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, LinkedList<StackEntry> stack) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple rootEntry = (LeftTuple)leftTuple.getRootTuple();
            DroolsQueryImpl dquery = (DroolsQueryImpl)rootEntry.getFactHandle().getObject();
            dquery.setQuery(qtnNode.getQuery());
            if (dquery.getStackEntry() != null) {
                PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(activationsManager, stack, rootEntry, dquery);
            }
            dquery.getQueryResultCollector().rowRemoved((RuleImpl)qtnNode.getQuery(), leftTuple, activationsManager.getReteEvaluator());
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void checkAndTriggerQueryReevaluation(ActivationsManager activationsManager, LinkedList<StackEntry> stack, Tuple rootEntry, DroolsQueryImpl dquery) {
        StackEntry stackEntry = dquery.getStackEntry();
        if (!PhreakQueryTerminalNode.isAdded(stack, stackEntry)) {
            ((QueryElementNode.QueryElementNodeMemory)stackEntry.getNodeMem()).setNodeDirtyWithoutNotify();
            if (stackEntry.getRmem().getPathEndNode().getPathNodes()[0] == ((LeftTupleSink)rootEntry.getTupleSink()).getLeftTupleSource()) {
                stack.add(stackEntry);
            } else {
                List<PathMemory> pmems = dquery.getRuleMemories();
                if (pmems != null) {
                    int length = pmems.size();
                    for (int i = 0; i < length; ++i) {
                        PathMemory pmem = pmems.get(i);
                        pmem.doLinkRule(activationsManager);
                    }
                }
            }
        }
    }

    public static boolean isAdded(LinkedList<StackEntry> stack, StackEntry stackEntry) {
        return stackEntry == null || stackEntry.getPrevious() != null || stackEntry.getNext() != null || stack.getFirst() == stackEntry;
    }
}

