/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.util.HashSet;
import java.util.Set;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.spi.Activation;
import org.kie.api.runtime.rule.RuleUnit;

public class Guard {
    private final RuleUnit guardedUnit;
    private final RuleImpl guardingRule;
    private final Set<Activation> activations = new HashSet<Activation>();

    public Guard(RuleUnit guardedUnit, RuleImpl guardingRule) {
        this.guardedUnit = guardedUnit;
        this.guardingRule = guardingRule;
    }

    public Set<Activation> getActivations() {
        return this.activations;
    }

    public void addActivation(Activation activation) {
        this.activations.add(activation);
    }

    public void removeActivation(Activation activation) {
        this.activations.remove(activation);
    }

    public boolean isActive() {
        return !this.activations.isEmpty();
    }

    public RuleUnit getGuardedUnit() {
        return this.guardedUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Guard guard = (Guard)o;
        return this.guardedUnit.equals(guard.guardedUnit) && this.guardingRule.equals(guard.guardingRule);
    }

    public int hashCode() {
        int result = this.guardedUnit.hashCode();
        result = 31 * result + this.guardingRule.hashCode();
        return result;
    }
}

