/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.ReturnValueExpression;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.security.KiePolicyHelper;

public class JavaAccumulatorFunctionExecutor
implements Accumulator,
Externalizable,
Wireable {
    private static final long serialVersionUID = 510L;
    private ReturnValueExpression expression;
    private AccumulateFunction function;

    public JavaAccumulatorFunctionExecutor() {
    }

    public JavaAccumulatorFunctionExecutor(AccumulateFunction function) {
        this.function = function;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (ReturnValueExpression)in.readObject();
        this.function = (AccumulateFunction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.expression instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.function);
    }

    @Override
    public Serializable createContext() {
        JavaAccumulatorFunctionContext context = new JavaAccumulatorFunctionContext();
        context.context = this.function.createContext();
        if (this.function.supportsReverse()) {
            context.reverseSupport = new HashMap<Integer, Object>();
        }
        return context;
    }

    @Override
    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        this.function.init(((JavaAccumulatorFunctionContext)context).context);
    }

    @Override
    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object value = this.expression.evaluate(handle, leftTuple, declarations, innerDeclarations, workingMemory, workingMemoryContext).getValue();
        if (this.function.supportsReverse()) {
            ((JavaAccumulatorFunctionContext)context).reverseSupport.put(handle.getId(), value);
        }
        this.function.accumulate(((JavaAccumulatorFunctionContext)context).context, value);
    }

    @Override
    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object value = ((JavaAccumulatorFunctionContext)context).reverseSupport.remove(handle.getId());
        this.function.reverse(((JavaAccumulatorFunctionContext)context).context, value);
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        return this.function.getResult(((JavaAccumulatorFunctionContext)context).context);
    }

    @Override
    public boolean supportsReverse() {
        return this.function.supportsReverse();
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    @Override
    public void wire(Object object) {
        this.setExpression(KiePolicyHelper.isPolicyEnabled() ? new ReturnValueExpression.SafeReturnValueExpression((ReturnValueExpression)object) : (ReturnValueExpression)object);
    }

    public void setExpression(ReturnValueExpression expression) {
        this.expression = expression;
    }

    @Override
    public Object createWorkingMemoryContext() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaAccumulatorFunctionExecutor that = (JavaAccumulatorFunctionExecutor)o;
        return this.expression.equals(that.expression) && this.function.equals(that.function);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }

    public static class JavaAccumulatorFunctionContext
    implements Externalizable {
        public Serializable context;
        public Map<Integer, Object> reverseSupport;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (Externalizable)in.readObject();
            this.reverseSupport = (Map)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.reverseSupport);
        }

        public Collection<Object> getAccumulatedObjects() {
            return this.reverseSupport == null ? null : this.reverseSupport.values();
        }

        public String toString() {
            return this.context.toString();
        }
    }
}

