/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class IntegerMaxAccumulateFunction
extends AbstractAccumulateFunction<MaxData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public MaxData createContext() {
        return new MaxData();
    }

    public void init(MaxData data) {
        data.max = null;
    }

    public void accumulate(MaxData data, Object value) {
        if (value != null) {
            Integer number = (Integer)value;
            data.max = data.max == null || data.max < number ? number : data.max;
        }
    }

    public void reverse(MaxData data, Object value) {
    }

    public boolean tryReverse(MaxData data, Object value) {
        if (value != null) {
            Integer number = (Integer)value;
            return data.max > number;
        }
        return true;
    }

    public Object getResult(MaxData data) {
        return data.max;
    }

    public boolean supportsReverse() {
        return false;
    }

    public Class<?> getResultType() {
        return Integer.class;
    }

    protected static class MaxData
    implements Externalizable {
        public Integer max = null;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.max = (Integer)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.max);
        }

        public String toString() {
            return "max";
        }
    }
}

