/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedListNode;

public class LinkedList<T extends LinkedListNode<T>>
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private T firstNode;
    private T lastNode;
    private int size;
    public static final FastIterator fastIterator = new LinkedListFastIterator();

    public LinkedList() {
    }

    public LinkedList(T node) {
        this.firstNode = node;
        this.lastNode = node;
        ++this.size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.firstNode = (LinkedListNode)in.readObject();
        this.lastNode = (LinkedListNode)in.readObject();
        this.size = in.readInt();
        LinkedListNode current = this.firstNode;
        Object previous = null;
        while (current != this.lastNode) {
            LinkedListNode next = (LinkedListNode)in.readObject();
            current.setPrevious(previous);
            current.setNext((LinkedListNode)next);
            previous = current;
            current = next;
        }
        if (current != null) {
            current.setPrevious(previous);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.firstNode);
        out.writeObject(this.lastNode);
        out.writeInt(this.size);
        if (this.firstNode == this.lastNode) {
            return;
        }
        for (Object node = this.firstNode; node != null; node = (LinkedListNode)node.getNext()) {
            out.writeObject(node.getNext());
        }
    }

    public void add(T node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNext(node);
            node.setPrevious(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void addLast(T node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            T currentLast = this.lastNode;
            currentLast.setNext(node);
            node.setPrevious(currentLast);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void addFirst(T node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            T currentFirst = this.firstNode;
            currentFirst.setPrevious(node);
            node.setNext(currentFirst);
            this.firstNode = node;
        }
        ++this.size;
    }

    public void remove(T node) {
        if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        } else {
            node.getPrevious().setNext((LinkedListNode)((LinkedListNode)node.getNext()));
            ((LinkedListNode)node.getNext()).setPrevious(node.getPrevious());
            --this.size;
            node.setPrevious(null);
            node.setNext(null);
        }
    }

    public boolean contains(T node) {
        for (Object currentNode = this.firstNode; currentNode != null; currentNode = (LinkedListNode)currentNode.getNext()) {
            if (currentNode != node) continue;
            return true;
        }
        return false;
    }

    public final T getFirst() {
        return this.firstNode;
    }

    public final T getLast() {
        return this.lastNode;
    }

    public T removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        T node = this.firstNode;
        this.firstNode = (LinkedListNode)node.getNext();
        node.setNext(null);
        if (this.firstNode != null) {
            this.firstNode.setPrevious(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public void insertAfter(T existingNode, T newNode) {
        if (newNode.getPrevious() != null || newNode.getNext() != null) {
            return;
        }
        if (existingNode == null) {
            if (this.isEmpty()) {
                this.firstNode = newNode;
                this.lastNode = newNode;
            } else {
                T node = this.firstNode;
                node.setPrevious(newNode);
                newNode.setNext(node);
                this.firstNode = newNode;
            }
        } else if (existingNode == this.lastNode) {
            existingNode.setNext(newNode);
            newNode.setPrevious(existingNode);
            this.lastNode = newNode;
        } else {
            ((LinkedListNode)existingNode.getNext()).setPrevious(newNode);
            newNode.setNext((LinkedListNode)((LinkedListNode)existingNode.getNext()));
            existingNode.setNext(newNode);
            newNode.setPrevious(existingNode);
        }
        ++this.size;
    }

    public T removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        T node = this.lastNode;
        this.lastNode = node.getPrevious();
        node.setPrevious(null);
        if (this.lastNode != null) {
            this.lastNode.setNext(null);
        } else {
            this.firstNode = null;
        }
        --this.size;
        return node;
    }

    public T get(int i) {
        Object current = this.getFirst();
        for (int j = 0; j < i; ++j) {
            current = (LinkedListNode)current.getNext();
        }
        return current;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        for (Object node = this.firstNode; node != null; node = (LinkedListNode)node.getNext()) {
            result = 31 * result + node.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LinkedList)) {
            return false;
        }
        LinkedList other = (LinkedList)object;
        if (this.size() != other.size()) {
            return false;
        }
        Object thisNode = this.firstNode;
        for (Object otherNode = other.firstNode; thisNode != null && otherNode != null; thisNode = (LinkedListNode)thisNode.getNext(), otherNode = (LinkedListNode)otherNode.getNext()) {
            if (thisNode.equals(otherNode)) continue;
            return false;
        }
        return true;
    }

    public FastIterator iterator() {
        return this.fastIterator();
    }

    public FastIterator fastIterator() {
        return fastIterator;
    }

    public java.util.Iterator<T> javaUtilIterator() {
        return new JavaUtilIterator(this);
    }

    public static class JavaUtilIterator<T extends LinkedListNode<T>>
    implements java.util.Iterator<T>,
    Externalizable {
        private LinkedList<T> list;
        private T currentNode;
        private T nextNode;
        private boolean immutable;

        public JavaUtilIterator() {
        }

        public JavaUtilIterator(LinkedList<T> list) {
            this(list, true);
        }

        public JavaUtilIterator(LinkedList<T> list, boolean immutable) {
            this.list = list;
            this.nextNode = this.list.getFirst();
            this.immutable = immutable;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (LinkedList)in.readObject();
            this.currentNode = (LinkedListNode)in.readObject();
            this.nextNode = (LinkedListNode)in.readObject();
            this.immutable = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
            out.writeObject(this.currentNode);
            out.writeObject(this.nextNode);
            out.writeBoolean(this.immutable);
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public T next() {
            this.currentNode = this.nextNode;
            if (this.currentNode == null) {
                throw new NoSuchElementException("No more elements to return");
            }
            this.nextNode = (LinkedListNode)this.currentNode.getNext();
            return this.currentNode;
        }

        @Override
        public void remove() {
            if (this.immutable) {
                throw new UnsupportedOperationException("This  Iterator is immutable, you cannot call remove()");
            }
            if (this.currentNode == null) {
                throw new IllegalStateException("No item to remove. Call next() before calling remove().");
            }
            this.list.remove(this.currentNode);
            this.currentNode = null;
        }
    }

    public static class LinkedListIterator<T extends LinkedListNode<T>>
    implements Iterator<T>,
    Externalizable {
        private LinkedList<T> list;
        private T current;

        public void reset(LinkedList<T> list) {
            this.list = list;
            this.current = ((LinkedList)this.list).firstNode;
        }

        @Override
        public T next() {
            if (this.current == null) {
                return null;
            }
            T node = this.current;
            this.current = (LinkedListNode)this.current.getNext();
            return node;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (LinkedList)in.readObject();
            this.current = (LinkedListNode)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
            out.writeObject(this.current);
        }
    }

    public static class LinkedListFastIterator
    implements FastIterator {
        @Override
        public Entry next(Entry object) {
            return object.getNext();
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

