/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.compiled;

import org.drools.core.base.ClassFieldReader;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.compiled.AbstractCompilerHandler;
import org.drools.core.spi.PropagationContext;

public class AssertHandler
extends AbstractCompilerHandler {
    private static final String LOCAL_FACT_VAR_NAME = "fact";
    private static final String FACT_HANDLE_PARAM_TYPE = InternalFactHandle.class.getName();
    private static final String PROP_CONTEXT_PARAM_TYPE = PropagationContext.class.getName();
    private static final String WORKING_MEMORY_PARAM_TYPE = InternalWorkingMemory.class.getName();
    private static final String FACT_HANDLE_PARAM_NAME = "handle";
    private static final String PROP_CONTEXT_PARAM_NAME = "context";
    private static final String WORKING_MEMORY_PARAM_NAME = "wm";
    private static final String ASSERT_METHOD_SIGNATURE = "public final void assertObject(" + FACT_HANDLE_PARAM_TYPE + " " + "handle" + "," + PROP_CONTEXT_PARAM_TYPE + " " + "context" + "," + WORKING_MEMORY_PARAM_TYPE + " " + "wm" + "){";
    private final boolean alphaNetContainsHashedField;
    private final StringBuilder builder;
    private final String factClassName;

    AssertHandler(StringBuilder builder, String factClassName) {
        this(builder, factClassName, false);
    }

    public AssertHandler(StringBuilder builder, String factClassName, boolean alphaNetContainsHashedField) {
        this.builder = builder;
        this.factClassName = factClassName;
        this.alphaNetContainsHashedField = alphaNetContainsHashedField;
    }

    @Override
    public void startObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append(ASSERT_METHOD_SIGNATURE).append("\n");
        if (this.alphaNetContainsHashedField) {
            this.builder.append(this.factClassName).append(" ").append(LOCAL_FACT_VAR_NAME).append(" = (").append(this.factClassName).append(")").append(FACT_HANDLE_PARAM_NAME).append(".getObject();").append("\n");
        }
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.builder.append(this.getVariableName(betaNode)).append(".assertObject(").append(FACT_HANDLE_PARAM_NAME).append(",").append(PROP_CONTEXT_PARAM_NAME).append(",").append(WORKING_MEMORY_PARAM_NAME).append(");").append("\n");
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append(this.getVariableName(leftInputAdapterNode)).append(".assertObject(").append(FACT_HANDLE_PARAM_NAME).append(",").append(PROP_CONTEXT_PARAM_NAME).append(",").append(WORKING_MEMORY_PARAM_NAME).append(");").append("\n");
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("if ( ").append(this.getVariableName(alphaNode)).append(".isAllowed(").append(FACT_HANDLE_PARAM_NAME).append(",").append(WORKING_MEMORY_PARAM_NAME).append(", ").append(this.getContextVariableName(alphaNode)).append(") ) {").append("\n");
    }

    @Override
    public void endNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("}").append("\n");
    }

    @Override
    public void startHashedAlphaNodes(ClassFieldReader hashedFieldReader) {
        String attributeName = hashedFieldReader.getFieldName();
        String localVariableName = attributeName + "NodeId";
        String attributeGetterName = "get" + Character.toTitleCase(attributeName.charAt(0)) + attributeName.substring(1);
        this.builder.append("Integer ").append(localVariableName);
        this.builder.append(" = (Integer)").append(this.getVariableName(hashedFieldReader)).append(".get(").append(LOCAL_FACT_VAR_NAME).append(".").append(attributeGetterName).append("());").append("\n");
        this.builder.append("if(").append(localVariableName).append(" != null) {").append("\n");
        this.builder.append("switch(").append(localVariableName).append(".intValue()) {").append("\n");
    }

    @Override
    public void startHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.builder.append("case ").append(hashedAlpha.getId()).append(" : ").append("\n");
    }

    @Override
    public void endHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.builder.append("break;").append("\n");
    }

    @Override
    public void endHashedAlphaNodes(ClassFieldReader hashedFieldReader) {
        this.builder.append("}").append("\n");
        this.builder.append("}").append("\n");
    }

    @Override
    public void endObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append("}").append("\n");
    }
}

