/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;

@XmlRootElement(name="class-object-filter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClassObjectSerializationFilter
implements ObjectFilter {
    @XmlAttribute(name="string", required=true)
    private String className = null;
    private transient Class filteredClass;
    private transient boolean skipLoadClass;

    public ClassObjectSerializationFilter() {
    }

    public ClassObjectSerializationFilter(Class clazz) {
        this.className = clazz.getCanonicalName();
        this.filteredClass = clazz;
    }

    public ClassObjectSerializationFilter(ClassObjectFilter objectFilter) {
        this(objectFilter.getFilteredClass());
    }

    public Class getFilteredClass() {
        return this.filteredClass;
    }

    public void setFilteredClass(Class filteredClass) {
        this.filteredClass = filteredClass;
    }

    public boolean accept(Object object) {
        if (!this.skipLoadClass && this.filteredClass == null) {
            try {
                this.filteredClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                this.skipLoadClass = true;
            }
        }
        return this.skipLoadClass ? this.className.equals(object.getClass().getCanonicalName()) : this.filteredClass.isAssignableFrom(object.getClass());
    }
}

