/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.compiled;

import org.drools.core.base.ClassFieldReader;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkNodeList;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.reteoo.compiled.NetworkHandler;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;

public class ObjectTypeNodeParser {
    private final ObjectTypeNode objectTypeNode;

    public ObjectTypeNodeParser(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
    }

    public void accept(NetworkHandler handler) {
        ObjectSinkPropagator propagator = this.objectTypeNode.getObjectSinkPropagator();
        handler.startObjectTypeNode(this.objectTypeNode);
        this.traversePropagator(propagator, handler);
        handler.endObjectTypeNode(this.objectTypeNode);
    }

    private void traversePropagator(ObjectSinkPropagator propagator, NetworkHandler handler) {
        if (propagator instanceof SingleObjectSinkAdapter) {
            ObjectSink sink = propagator.getSinks()[0];
            this.traverseSink(sink, handler);
        } else if (propagator instanceof CompositeObjectSinkAdapter) {
            CompositeObjectSinkAdapter composite = (CompositeObjectSinkAdapter)propagator;
            this.traverseSinkLisk(composite.getHashableSinks(), handler);
            this.traverseSinkLisk(composite.getOthers(), handler);
            this.traverseHashedAlphaNodes(composite.getHashedSinkMap(), handler);
        }
    }

    private void traversePropagator(LeftTupleSinkPropagator propagator, NetworkHandler handler) {
        if (propagator instanceof SingleLeftTupleSinkAdapter) {
            LeftTupleSink sink = propagator.getSinks()[0];
            this.traverseSink(sink, handler);
        } else if (propagator instanceof CompositeLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter composite = (CompositeLeftTupleSinkAdapter)propagator;
            LeftTupleSink[] sinks = composite.getSinks();
            this.traverseSinkLisk(sinks, handler);
        }
    }

    private void traverseSinkLisk(ObjectSinkNodeList sinks, NetworkHandler handler) {
        if (sinks != null) {
            for (ObjectSinkNode sink = sinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.traverseSink(sink, handler);
            }
        }
    }

    private void traverseSinkLisk(LeftTupleSink[] sinks, NetworkHandler handler) {
        if (sinks != null) {
            for (int sinkIndex = 0; sinkIndex < sinks.length; ++sinkIndex) {
                this.traverseSink(sinks[sinkIndex], handler);
            }
        }
    }

    private void traverseHashedAlphaNodes(ObjectHashMap hashedAlphaNodes, NetworkHandler handler) {
        if (hashedAlphaNodes != null && hashedAlphaNodes.size() > 0) {
            AlphaNode firstAlpha = this.getFirstAlphaNode(hashedAlphaNodes);
            ClassFieldReader hashedFieldReader = this.getClassFieldReaderForHashedAlpha(firstAlpha);
            handler.startHashedAlphaNodes(hashedFieldReader);
            Iterator iter = hashedAlphaNodes.iterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
            while (entry != null) {
                CompositeObjectSinkAdapter.HashKey hashKey = (CompositeObjectSinkAdapter.HashKey)entry.getKey();
                AlphaNode alphaNode = (AlphaNode)entry.getValue();
                handler.startHashedAlphaNode(alphaNode, hashKey.getObjectValue());
                this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
                handler.endHashedAlphaNode(alphaNode, hashKey.getObjectValue());
                entry = (ObjectHashMap.ObjectEntry)iter.next();
            }
            handler.endHashedAlphaNodes(hashedFieldReader);
        }
    }

    private void traverseSink(ObjectSink sink, NetworkHandler handler) {
        if (sink.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)sink;
            handler.startNonHashedAlphaNode(alphaNode);
            this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
            handler.endNonHashedAlphaNode(alphaNode);
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            handler.startBetaNode(betaNode);
            handler.endBetaNode(betaNode);
        } else if (sink.getType() == 120) {
            LeftInputAdapterNode leftInputAdapterNode = (LeftInputAdapterNode)sink;
            handler.startLeftInputAdapterNode(leftInputAdapterNode);
            handler.endLeftInputAdapterNode(leftInputAdapterNode);
        }
    }

    private void traverseSink(LeftTupleSink sink, NetworkHandler handler) {
    }

    private AlphaNode getFirstAlphaNode(ObjectHashMap hashedAlphaNodes) throws IllegalArgumentException {
        Iterator iter = hashedAlphaNodes.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
        if (entry == null) {
            throw new IllegalArgumentException("ObjectHashMap does not contain any hashed AlphaNodes!");
        }
        AlphaNode firstAlphaNode = (AlphaNode)entry.getValue();
        return firstAlphaNode;
    }

    private ClassFieldReader getClassFieldReaderForHashedAlpha(AlphaNode alphaNode) throws IllegalArgumentException {
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (!(fieldConstraint instanceof MvelConstraint)) {
            throw new IllegalArgumentException("Only support MvelConstraint hashed AlphaNodes, not " + fieldConstraint.getClass());
        }
        return (ClassFieldReader)((MvelConstraint)fieldConstraint).getFieldExtractor();
    }
}

