/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInput;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.KieBaseEventSupport;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KieSessionsPoolImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Function;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.TripleStore;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Role;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.internal.weaver.KieWeavers;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.KieSessionsPool;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.definition.KnowledgeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBaseImpl
implements InternalKnowledgeBase,
Externalizable {
    protected static final transient Logger logger = LoggerFactory.getLogger(KnowledgeBaseImpl.class);
    private static final long serialVersionUID = 510L;
    private Set<EntryPointNode> addedEntryNodeCache;
    private Set<EntryPointNode> removedEntryNodeCache;
    private String id;
    private final AtomicInteger workingMemoryCounter = new AtomicInteger(0);
    private RuleBaseConfiguration config;
    protected Map<String, InternalKnowledgePackage> pkgs;
    private Map<String, Process> processes;
    private transient ClassLoader rootClassLoader;
    private FactHandleFactory factHandleFactory;
    private transient Map<String, Class<?>> globals;
    private final transient Queue<DialectRuntimeRegistry> reloadPackageCompilationData = new ConcurrentLinkedQueue<DialectRuntimeRegistry>();
    private KieBaseEventSupport eventSupport = new KieBaseEventSupport(this);
    private final transient Set<StatefulKnowledgeSessionImpl> statefulSessions = ConcurrentHashMap.newKeySet();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final transient Map<String, TypeDeclaration> classTypeDeclaration = new ConcurrentHashMap<String, TypeDeclaration>();
    private ClassFieldAccessorCache classFieldAccessorCache;
    private transient Rete rete;
    private ReteooBuilder reteooBuilder;
    private transient Map<Integer, SegmentMemory.Prototype> segmentProtos = new ConcurrentHashMap<Integer, SegmentMemory.Prototype>();
    private KieComponentFactory kieComponentFactory;
    public List<List<String>> jaxbClasses;
    public final Set<KieBaseEventListener> kieBaseListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private transient Queue<Runnable> kbaseModificationsQueue = new ConcurrentLinkedQueue<Runnable>();
    private transient AtomicInteger sessionDeactivationsCounter = new AtomicInteger();
    private transient AtomicBoolean flushingUpdates = new AtomicBoolean(false);
    private transient InternalKieContainer kieContainer;
    private ReleaseId resolvedReleaseId;
    private String containerId;
    private AtomicBoolean mbeanRegistered = new AtomicBoolean(false);
    private RuleUnitDescriptionRegistry ruleUnitDescriptionRegistry = new RuleUnitDescriptionRegistry();
    private SessionConfiguration sessionConfiguration;
    private List<AsyncReceiveNode> receiveNodes;
    private KieSessionsPool sessionPool;

    public KnowledgeBaseImpl() {
    }

    public KnowledgeBaseImpl(String id, RuleBaseConfiguration config) {
        this.config = config != null ? config : new RuleBaseConfiguration();
        this.config.makeImmutable();
        this.createRulebaseId(id);
        this.rootClassLoader = this.config.getClassLoader();
        this.pkgs = new HashMap<String, InternalKnowledgePackage>();
        this.processes = new HashMap<String, Process>();
        this.globals = new HashMap();
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.kieComponentFactory = this.getConfiguration().getComponentFactory();
        this.factHandleFactory = this.kieComponentFactory.getFactHandleFactoryService();
        this.kieComponentFactory.getTraitFactory().setRuleBase(this);
        this.kieComponentFactory.getTripleStore().setId(id);
        this.setupRete();
        this.sessionConfiguration = new SessionConfigurationImpl(null, this.config.getClassLoader(), this.config.getChainedProperties());
        if (this.config.getSessionPoolSize() > 0) {
            this.sessionPool = this.newKieSessionsPool(this.config.getSessionPoolSize());
        }
    }

    @Override
    public void initMBeans() {
        if (this.config != null && this.config.isMBeansEnabled() && this.mbeanRegistered.compareAndSet(false, true)) {
            DroolsManagementAgent.getInstance().registerKnowledgeBase(this);
        }
    }

    @Override
    public int nextWorkingMemoryCounter() {
        return this.workingMemoryCounter.getAndIncrement();
    }

    @Override
    public int getWorkingMemoryCounter() {
        return this.workingMemoryCounter.get();
    }

    private void createRulebaseId(String id) {
        if (id != null) {
            this.id = id;
        } else {
            String key = "";
            if (this.config.isMBeansEnabled()) {
                DroolsManagementAgent agent = DroolsManagementAgent.getInstance();
                key = String.valueOf(agent.getNextKnowledgeBaseId());
            }
            this.id = "default" + key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(KieBaseEventListener listener) {
        Set<KieBaseEventListener> set = this.kieBaseListeners;
        synchronized (set) {
            if (!this.kieBaseListeners.contains(listener)) {
                this.eventSupport.addEventListener(listener);
                this.kieBaseListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(KieBaseEventListener listener) {
        Set<KieBaseEventListener> set = this.kieBaseListeners;
        synchronized (set) {
            this.eventSupport.removeEventListener(listener);
            this.kieBaseListeners.remove(listener);
        }
    }

    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return Collections.unmodifiableCollection(this.kieBaseListeners);
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public void removeKiePackage(String packageName) {
        this.enqueueModification(() -> {
            InternalKnowledgePackage pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            this.eventSupport.fireBeforePackageRemoved(pkg);
            this.internalRemoveRules(pkg.getRules());
            HashSet<String> referencedGlobals = new HashSet<String>();
            for (InternalKnowledgePackage pkgref : this.pkgs.values()) {
                if (pkgref == pkg) continue;
                referencedGlobals.addAll(pkgref.getGlobals().keySet());
            }
            for (String globalName : pkg.getGlobals().keySet()) {
                if (referencedGlobals.contains(globalName)) continue;
                this.globals.remove(globalName);
            }
            for (String processName : new ArrayList<String>(pkg.getRuleFlows().keySet())) {
                this.internalRemoveProcess(processName);
            }
            this.pkgs.remove(pkg.getName());
            pkg.getDialectRuntimeRegistry().onRemove();
            pkg.clear();
            this.eventSupport.fireAfterPackageRemoved(pkg);
        });
    }

    public Rule getRule(String packageName, String ruleName) {
        InternalKnowledgePackage p = this.getPackage(packageName);
        return p == null ? null : p.getRule(ruleName);
    }

    public Query getQuery(String packageName, String queryName) {
        return this.getPackage(packageName).getRule(queryName);
    }

    public KieSessionsPool newKieSessionsPool(int initialSize) {
        return new KieSessionsPoolImpl(this, initialSize);
    }

    public KieSession newKieSession() {
        return this.newKieSession(null, EnvironmentFactory.newEnvironment());
    }

    public KieSession newKieSession(KieSessionConfiguration conf, Environment environment) {
        return this.newKieSession(conf, environment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KieSession newKieSession(KieSessionConfiguration conf, Environment environment, boolean fromPool) {
        if (conf == null) {
            conf = this.getSessionConfiguration();
        }
        SessionConfiguration sessionConfig = (SessionConfiguration)conf;
        if (environment == null) {
            environment = EnvironmentFactory.newEnvironment();
        }
        if (this.getConfiguration().isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        this.readLock();
        try {
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = this.internalCreateStatefulKnowledgeSession(environment, sessionConfig, fromPool);
            return statefulKnowledgeSessionImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public StatefulKnowledgeSessionImpl createSession(long id, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        StatefulKnowledgeSessionImpl session = (StatefulKnowledgeSessionImpl)this.kieComponentFactory.getWorkingMemoryFactory().createWorkingMemory(id, this, handleFactory, propagationContext, config, agenda, environment);
        return this.internalInitSession(config, session);
    }

    public StatefulKnowledgeSessionImpl internalCreateStatefulKnowledgeSession(Environment environment, SessionConfiguration sessionConfig, boolean fromPool) {
        if (fromPool || this.sessionPool == null) {
            StatefulKnowledgeSessionImpl session = (StatefulKnowledgeSessionImpl)this.kieComponentFactory.getWorkingMemoryFactory().createWorkingMemory(this.nextWorkingMemoryCounter(), this, sessionConfig, environment);
            return this.internalInitSession(sessionConfig, session);
        }
        return (StatefulKnowledgeSessionImpl)this.sessionPool.newKieSession((KieSessionConfiguration)sessionConfig);
    }

    private StatefulKnowledgeSessionImpl internalInitSession(SessionConfiguration sessionConfig, StatefulKnowledgeSessionImpl session) {
        if (sessionConfig.isKeepReference()) {
            this.addStatefulSession(session);
        }
        return session;
    }

    public Collection<? extends KieSession> getKieSessions() {
        return Collections.unmodifiableSet(this.statefulSessions);
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        return new StatelessKnowledgeSessionImpl(this, conf);
    }

    public StatelessKieSession newStatelessKieSession() {
        return new StatelessKnowledgeSessionImpl(this, null);
    }

    public Collection<KiePackage> getKiePackages() {
        InternalKnowledgePackage[] knowledgePackages = this.getPackages();
        ArrayList<KiePackage> list = new ArrayList<KiePackage>(knowledgePackages.length);
        Collections.addAll(list, knowledgePackages);
        return list;
    }

    public KiePackage getKiePackage(String packageName) {
        return this.getPackage(packageName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInput droolsStream;
        boolean isDrools = in instanceof DroolsObjectInputStream;
        boolean wasDrools = in.readBoolean();
        if (wasDrools && !isDrools) {
            throw new IllegalArgumentException("The knowledge base was serialized using a DroolsObjectOutputStream. A DroolsObjectInputStream is required for deserialization.");
        }
        if (isDrools) {
            droolsStream = (DroolsObjectInput)in;
        } else {
            ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        droolsStream.readBoolean();
        Map store = (Map)droolsStream.readObject();
        this.rootClassLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)droolsStream.getParentClassLoader(), (Map)store);
        droolsStream.setClassLoader(this.rootClassLoader);
        droolsStream.setKnowledgeBase(this);
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.config = (RuleBaseConfiguration)droolsStream.readObject();
        this.config.setClassLoader(droolsStream.getParentClassLoader());
        this.sessionConfiguration = new SessionConfigurationImpl(null, this.config.getClassLoader(), this.config.getChainedProperties());
        this.kieComponentFactory = this.getConfiguration().getComponentFactory();
        this.pkgs = (Map)droolsStream.readObject();
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
        }
        this.id = (String)droolsStream.readObject();
        this.workingMemoryCounter.set(droolsStream.readInt());
        this.processes = (Map)droolsStream.readObject();
        String classNameFromStream = droolsStream.readUTF();
        try {
            Class<?> cls = droolsStream.getParentClassLoader().loadClass(classNameFromStream);
            this.factHandleFactory = (FactHandleFactory)cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            DroolsObjectInputStream.newInvalidClassException(classNameFromStream, (Throwable)e);
        }
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            pkg.getClassFieldAccessorStore().setClassFieldAccessorCache(this.classFieldAccessorCache);
            pkg.getClassFieldAccessorStore().wire();
        }
        this.populateTypeDeclarationMaps();
        Map globs = (Map)droolsStream.readObject();
        this.populateGlobalsMap(globs);
        this.eventSupport = (KieBaseEventSupport)droolsStream.readObject();
        this.eventSupport.setKnowledgeBase(this);
        this.reteooBuilder = (ReteooBuilder)droolsStream.readObject();
        this.reteooBuilder.setRuleBase(this);
        this.rete = (Rete)droolsStream.readObject();
        this.resolvedReleaseId = (ReleaseId)droolsStream.readObject();
        ((DroolsObjectInputStream)droolsStream).bindAllExtractors(this);
        if (!isDrools) {
            droolsStream.close();
        }
        this.getConfiguration().getComponentFactory().getTraitFactory().setRuleBase(this);
        this.rewireReteAfterDeserialization();
    }

    private void rewireReteAfterDeserialization() {
        for (EntryPointNode entryPointNode : this.rete.getEntryPointNodes().values()) {
            entryPointNode.setParentObjectSource(this.rete);
            this.rewireNodeAfterDeserialization(entryPointNode);
        }
    }

    private void rewireNodeAfterDeserialization(BaseNode node) {
        Sink[] sinks = node.getSinks();
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (sink instanceof ObjectSource) {
                    if (node instanceof ObjectSource) {
                        ((ObjectSource)((Object)sink)).setParentObjectSource((ObjectSource)node);
                    } else if (sink instanceof RightInputAdapterNode) {
                        ((RightInputAdapterNode)sink).setTupleSource((LeftTupleSource)node);
                    }
                } else if (sink instanceof LeftTupleSource) {
                    if (node instanceof LeftTupleSource) {
                        ((LeftTupleSource)((Object)sink)).setLeftTupleSource((LeftTupleSource)node);
                    } else if (sink instanceof BetaNode) {
                        ((BetaNode)sink).setRightInput((ObjectSource)node);
                    }
                }
                if (!(sink instanceof BaseNode)) continue;
                this.rewireNodeAfterDeserialization((BaseNode)((Object)sink));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream bytes;
        ObjectOutput droolsStream;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        out.writeBoolean(isDrools);
        if (out instanceof DroolsObjectOutputStream) {
            droolsStream = out;
            bytes = null;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        try {
            droolsStream.writeBoolean(this.config.isClassLoaderCacheEnabled());
            droolsStream.writeObject(((ProjectClassLoader)this.rootClassLoader).getStore());
            droolsStream.writeObject(this.config);
            droolsStream.writeObject(this.pkgs);
            droolsStream.writeObject(this.id);
            droolsStream.writeInt(this.workingMemoryCounter.get());
            droolsStream.writeObject(this.processes);
            droolsStream.writeUTF(this.factHandleFactory.getClass().getName());
            droolsStream.writeObject(this.buildGlobalMapForSerialization());
            this.eventSupport.removeEventListener(KieBaseEventListener.class);
            droolsStream.writeObject(this.eventSupport);
            droolsStream.writeObject(this.reteooBuilder);
            droolsStream.writeObject(this.rete);
            droolsStream.writeObject(this.resolvedReleaseId);
        }
        finally {
            if (bytes != null) {
                droolsStream.flush();
                droolsStream.close();
                bytes.close();
                out.writeObject(bytes.toByteArray());
            }
        }
    }

    private Map<String, String> buildGlobalMapForSerialization() {
        HashMap<String, String> gl = new HashMap<String, String>();
        for (Map.Entry<String, Class<?>> entry : this.globals.entrySet()) {
            gl.put(entry.getKey(), entry.getValue().getName());
        }
        return gl;
    }

    private void populateGlobalsMap(Map<String, String> globs) throws ClassNotFoundException {
        this.globals = new HashMap();
        for (Map.Entry<String, String> entry : globs.entrySet()) {
            this.addGlobal(entry.getKey(), this.rootClassLoader.loadClass(entry.getValue()));
        }
    }

    private void populateTypeDeclarationMaps() throws ClassNotFoundException {
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            for (TypeDeclaration type : pkg.getTypeDeclarations().values()) {
                type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                this.classTypeDeclaration.put(type.getTypeClassName(), type);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void disposeStatefulSession(StatefulKnowledgeSessionImpl statefulSession) {
        this.statefulSessions.remove(statefulSession);
        if (this.kieContainer != null) {
            this.kieContainer.disposeSession(statefulSession);
        }
    }

    @Override
    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    @Override
    public FactHandleFactory newFactHandleFactory(long id, long counter) {
        return this.factHandleFactory.newInstance(id, counter);
    }

    public Collection<Process> getProcesses() {
        this.readLock();
        try {
            Collection<Process> collection = this.processes.values();
            return collection;
        }
        finally {
            this.readUnlock();
        }
    }

    public InternalKnowledgePackage[] getPackages() {
        this.readLock();
        try {
            InternalKnowledgePackage[] internalKnowledgePackageArray = this.pkgs.values().toArray(new InternalKnowledgePackage[this.pkgs.size()]);
            return internalKnowledgePackageArray;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Map<String, InternalKnowledgePackage> getPackagesMap() {
        return this.pkgs;
    }

    @Override
    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    private void lock() {
        boolean firstLock;
        boolean bl = firstLock = !this.lock.isWriteLockedByCurrentThread();
        if (firstLock) {
            this.eventSupport.fireBeforeRuleBaseLocked();
        }
        this.lock.writeLock().lock();
        if (firstLock) {
            this.eventSupport.fireAfterRuleBaseLocked();
        }
    }

    private void unlock() {
        boolean lastUnlock;
        boolean bl = lastUnlock = this.lock.getWriteHoldCount() == 1;
        if (lastUnlock) {
            this.eventSupport.fireBeforeRuleBaseUnlocked();
        }
        this.lock.writeLock().unlock();
        if (lastUnlock) {
            this.eventSupport.fireAfterRuleBaseUnlocked();
        }
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public void addPackages(Collection<? extends KiePackage> newPkgs) {
        ArrayList<InternalKnowledgePackage> clonedPkgs = new ArrayList<InternalKnowledgePackage>();
        for (KiePackage kiePackage : newPkgs) {
            clonedPkgs.add(((InternalKnowledgePackage)kiePackage).deepCloneIfAlreadyInUse(this.rootClassLoader));
        }
        clonedPkgs.sort(Comparator.comparing(p -> p.getRules().size()).reversed().thenComparing(KiePackage::getName));
        this.enqueueModification(() -> this.internalAddPackages(clonedPkgs));
    }

    @Override
    public Future<KiePackage> addPackage(KiePackage newPkg) {
        InternalKnowledgePackage clonedPkg = ((InternalKnowledgePackage)newPkg).deepCloneIfAlreadyInUse(this.rootClassLoader);
        CompletableFuture<KiePackage> result = new CompletableFuture<KiePackage>();
        this.enqueueModification(() -> {
            this.internalAddPackages(Collections.singletonList(clonedPkg));
            result.complete(this.getPackage(newPkg.getName()));
        });
        return result;
    }

    @Override
    public void enqueueModification(Runnable modification) {
        if (this.tryLockAndDeactivate()) {
            try {
                modification.run();
            }
            finally {
                this.unlockAndActivate();
            }
        } else {
            this.kbaseModificationsQueue.offer(modification);
        }
    }

    @Override
    public boolean flushModifications() {
        if (!this.flushingUpdates.compareAndSet(false, true)) {
            return false;
        }
        if (this.kbaseModificationsQueue.isEmpty()) {
            this.flushingUpdates.set(false);
            return false;
        }
        try {
            this.lockAndDeactivate();
            while (!this.kbaseModificationsQueue.isEmpty()) {
                this.kbaseModificationsQueue.poll().run();
            }
        }
        finally {
            this.flushingUpdates.set(false);
            this.unlockAndActivate();
        }
        return true;
    }

    private void lockAndDeactivate() {
        this.lock();
        this.deactivateAllSessions();
    }

    private void unlockAndActivate() {
        this.activateAllSessions();
        this.unlock();
    }

    private boolean tryDeactivateAllSessions() {
        Collection<InternalWorkingMemory> wms = this.getWorkingMemories();
        if (wms.isEmpty()) {
            return true;
        }
        ArrayList<InternalWorkingMemory> deactivatedWMs = new ArrayList<InternalWorkingMemory>();
        for (InternalWorkingMemory wm : wms) {
            if (wm.tryDeactivate()) {
                deactivatedWMs.add(wm);
                continue;
            }
            for (InternalWorkingMemory deactivatedWM : deactivatedWMs) {
                deactivatedWM.activate();
            }
            return false;
        }
        return true;
    }

    private boolean tryLockAndDeactivate() {
        if (this.sessionDeactivationsCounter.incrementAndGet() > 1) {
            this.lock.writeLock().lock();
            return true;
        }
        boolean locked = this.lock.writeLock().tryLock();
        if (locked && !this.tryDeactivateAllSessions()) {
            this.lock.writeLock().unlock();
            locked = false;
        }
        if (!locked) {
            this.sessionDeactivationsCounter.decrementAndGet();
        }
        return locked;
    }

    private void deactivateAllSessions() {
        if (this.sessionDeactivationsCounter.incrementAndGet() < 2) {
            for (InternalWorkingMemory wm : this.getWorkingMemories()) {
                wm.deactivate();
            }
        }
    }

    private void activateAllSessions() {
        if (this.sessionDeactivationsCounter.decrementAndGet() == 0) {
            for (InternalWorkingMemory wm : this.getWorkingMemories()) {
                wm.activate();
            }
        }
    }

    private void internalAddPackages(Collection<InternalKnowledgePackage> clonedPkgs) {
        InternalKnowledgePackage pkg;
        for (InternalWorkingMemory wm : this.getWorkingMemories()) {
            wm.flushPropagations();
        }
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            newPkg.checkValidity();
            this.eventSupport.fireBeforePackageAdded(newPkg);
            if (newPkg.hasTraitRegistry()) {
                this.getTraitRegistry().merge(newPkg.getTraitRegistry());
            }
            if ((pkg = this.pkgs.get(newPkg.getName())) == null) {
                pkg = new KnowledgePackageImpl(newPkg.getName());
                pkg.setClassFieldAccessorCache(this.classFieldAccessorCache);
                this.pkgs.put(pkg.getName(), pkg);
            }
            pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader, true);
        }
        this.processAllTypesDeclaration(clonedPkgs);
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)newPkg.getDialectRuntimeRegistry().getDialectData("java");
            for (Function function : newPkg.getFunctions().values()) {
                String string = function.getClassName();
                try {
                    KnowledgeBaseImpl.registerFunctionClassAndInnerClasses(string, runtime, this::registerAndLoadTypeDefinition);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to compile function '" + function.getName() + "'", e);
                }
            }
        }
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            pkg = this.pkgs.get(newPkg.getName());
            if (newPkg.getFunctions() != null) {
                for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                    pkg.addFunction((Function)entry.getValue());
                }
            }
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
        }
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            pkg = this.pkgs.get(newPkg.getName());
            this.mergePackage(pkg, newPkg);
            for (WindowDeclaration windowDeclaration : newPkg.getWindowDeclarations().values()) {
                this.reteooBuilder.addNamedWindow(windowDeclaration);
            }
            for (String string : newPkg.getEntryPointIds()) {
                this.reteooBuilder.addEntryPoint(string);
            }
            for (Rule rule : newPkg.getRules()) {
                RuleImpl ruleImpl = (RuleImpl)rule;
                this.checkMultithreadedEvaluation(ruleImpl);
                this.internalAddRule(ruleImpl);
            }
            if (newPkg.getRuleFlows() != null) {
                Map<String, Process> flows = newPkg.getRuleFlows();
                for (Process process : flows.values()) {
                    this.internalAddProcess(process);
                }
            }
            if (!newPkg.getResourceTypePackages().isEmpty()) {
                KieWeavers weavers = (KieWeavers)ServiceRegistry.getInstance().get(KieWeavers.class);
                for (ResourceTypePackage<?> resourceTypePackage : newPkg.getResourceTypePackages().values()) {
                    weavers.weave((KieBase)this, (KiePackage)newPkg, resourceTypePackage);
                }
            }
            this.ruleUnitDescriptionRegistry.add(newPkg.getRuleUnitDescriptionLoader());
            this.eventSupport.fireAfterPackageAdded(newPkg);
        }
        if (this.config.isMultithreadEvaluation() && !this.hasMultiplePartitions()) {
            this.disableMultithreadEvaluation("The rete network cannot be partitioned: disabling multithread evaluation");
        }
    }

    @Override
    public void processAllTypesDeclaration(Collection<InternalKnowledgePackage> pkgs) {
        ArrayList<TypeDeclaration> allTypeDeclarations = new ArrayList<TypeDeclaration>();
        for (InternalKnowledgePackage newPkg : pkgs) {
            if (newPkg.getTypeDeclarations() == null) continue;
            allTypeDeclarations.addAll(newPkg.getTypeDeclarations().values());
        }
        Collections.sort(allTypeDeclarations);
        for (TypeDeclaration newDecl : allTypeDeclarations) {
            InternalKnowledgePackage newPkg = null;
            for (InternalKnowledgePackage kpkg : pkgs) {
                if (!kpkg.getTypeDeclarations().containsKey(newDecl.getTypeName())) continue;
                newPkg = kpkg;
                break;
            }
            try {
                this.processTypeDeclaration(newDecl, newPkg);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("unable to resolve Type Declaration class '" + newDecl.getTypeClassName() + "'", e);
            }
        }
    }

    private void checkMultithreadedEvaluation(RuleImpl rule) {
        if (this.config.isMultithreadEvaluation()) {
            if (!rule.isMainAgendaGroup()) {
                this.disableMultithreadEvaluation("Agenda-groups are not supported with multithread evaluation: disabling it");
            } else if (rule.getActivationGroup() != null) {
                this.disableMultithreadEvaluation("Activation-groups are not supported with multithread evaluation: disabling it");
            } else if (!rule.getSalience().isDefault()) {
                this.disableMultithreadEvaluation("Salience is not supported with multithread evaluation: disabling it");
            } else if (rule.isQuery()) {
                this.disableMultithreadEvaluation("Queries are not supported with multithread evaluation: disabling it");
            }
        }
    }

    private boolean hasMultiplePartitions() {
        for (EntryPointNode entryPointNode : this.rete.getEntryPointNodes().values()) {
            for (ObjectTypeNode otn : entryPointNode.getObjectTypeNodes().values()) {
                ObjectSinkPropagator sink = otn.getObjectSinkPropagator();
                if (!(sink instanceof CompositePartitionAwareObjectSinkAdapter) || ((CompositePartitionAwareObjectSinkAdapter)sink).getUsedPartitionsCount() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private void disableMultithreadEvaluation(String warningMessage) {
        this.config.enforceSingleThreadEvaluation();
        logger.warn(warningMessage);
        for (EntryPointNode entryPointNode : this.rete.getEntryPointNodes().values()) {
            entryPointNode.setPartitionsEnabled(false);
            for (ObjectTypeNode otn : entryPointNode.getObjectTypeNodes().values()) {
                ObjectSinkPropagator sink = otn.getObjectSinkPropagator();
                if (!(sink instanceof CompositePartitionAwareObjectSinkAdapter)) continue;
                otn.setObjectSinkPropagator(((CompositePartitionAwareObjectSinkAdapter)sink).asNonPartitionedSinkPropagator(this.config.getAlphaNodeHashingThreshold()));
            }
        }
    }

    public static void registerFunctionClassAndInnerClasses(String functionClassName, JavaDialectRuntimeData runtime, ClassRegister consumer) throws ClassNotFoundException {
        String className = ClassUtils.convertClassToResourcePath(functionClassName);
        String innerClassName = className.substring(0, className.length() - ".class".length()) + "$";
        for (Map.Entry<String, byte[]> entry : runtime.getStore().entrySet()) {
            if (entry.getKey().equals(className)) {
                consumer.register(functionClassName, entry.getValue());
                continue;
            }
            if (!entry.getKey().startsWith(innerClassName)) continue;
            String innerName = functionClassName + entry.getKey().substring(functionClassName.length(), entry.getKey().length() - ".class".length());
            consumer.register(innerName, entry.getValue());
        }
    }

    @Override
    public void registerTypeDeclaration(TypeDeclaration newDecl, InternalKnowledgePackage newPkg) {
        this.classTypeDeclaration.put(newDecl.getTypeClassName(), newDecl);
    }

    protected void processTypeDeclaration(TypeDeclaration newDecl, InternalKnowledgePackage newPkg) throws ClassNotFoundException {
        JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)newPkg.getDialectRuntimeRegistry().getDialectData("java");
        TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(newDecl.getTypeClassName());
        if (typeDeclaration == null) {
            byte[] def;
            String className = newDecl.getTypeClassName();
            Class<?> definedKlass = this.registerAndLoadTypeDefinition(className, def = runtime != null ? runtime.getClassDefinition(ClassUtils.convertClassToResourcePath(className)) : null);
            if (definedKlass == null && newDecl.isNovel()) {
                throw new RuntimeException("Registering null bytes for class " + className);
            }
            if (newDecl.getTypeClassDef() == null) {
                newDecl.setTypeClassDef(new ClassDefinition());
            }
            newDecl.setTypeClass(definedKlass);
            this.classTypeDeclaration.put(className, newDecl);
            typeDeclaration = newDecl;
        } else {
            Class<?> definedKlass = typeDeclaration.getTypeClass();
            newDecl.getTypeClassDef().setDefinedClass(definedKlass);
            newDecl.setTypeClass(definedKlass);
            this.mergeTypeDeclarations(typeDeclaration, newDecl);
        }
        this.updateDependentTypes(typeDeclaration);
    }

    @Override
    public Class<?> registerAndLoadTypeDefinition(String className, byte[] def) throws ClassNotFoundException {
        try {
            return this.rootClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (def != null && this.rootClassLoader instanceof ProjectClassLoader) {
                return ((ProjectClassLoader)this.rootClassLoader).defineClass(className, def);
            }
            throw e;
        }
    }

    private void updateDependentTypes(TypeDeclaration typeDeclaration) {
        if (this.getConfiguration().getEventProcessingMode().equals((Object)EventProcessingOption.STREAM)) {
            long exp = typeDeclaration.getExpirationOffset() > -1L ? typeDeclaration.getExpirationOffset() + 1L : -1L;
            for (EntryPointNode ep : this.rete.getEntryPointNodes().values()) {
                for (ObjectTypeNode node : ep.getObjectTypeNodes().values()) {
                    if (!node.isAssignableFrom(typeDeclaration.getObjectType())) continue;
                    node.setExpirationOffset(Math.max(node.getExpirationOffset(), exp));
                }
            }
        }
    }

    private void mergeTypeDeclarations(TypeDeclaration existingDecl, TypeDeclaration newDecl) {
        if (!(ClassUtils.areNullSafeEquals((Object)existingDecl.getFormat(), (Object)newDecl.getFormat()) && ClassUtils.areNullSafeEquals(existingDecl.getObjectType(), newDecl.getObjectType()) && ClassUtils.areNullSafeEquals(existingDecl.getTypeClassName(), newDecl.getTypeClassName()) && ClassUtils.areNullSafeEquals(existingDecl.getTypeName(), newDecl.getTypeName()))) {
            throw new RuntimeException("Unable to merge Type Declaration for class '" + existingDecl.getTypeName() + "'");
        }
        existingDecl.setDurationAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @duration attribute for type declaration of class:", existingDecl.getDurationAttribute(), newDecl.getDurationAttribute(), true, false));
        existingDecl.setDynamic(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyChangeSupport  (a.k.a. dynamic) attribute for type declaration of class:", existingDecl.isDynamic(), newDecl.isDynamic(), true, false));
        existingDecl.setPropertyReactive(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyReactive attribute for type declaration of class:", existingDecl.isPropertyReactive(), newDecl.isPropertyReactive(), true, false));
        if (newDecl.getExpirationPolicy() == Expires.Policy.TIME_HARD) {
            if (existingDecl.getExpirationPolicy() == Expires.Policy.TIME_SOFT || newDecl.getExpirationOffset() > existingDecl.getExpirationOffset()) {
                existingDecl.setExpirationOffset(newDecl.getExpirationOffset());
                existingDecl.setExpirationType(Expires.Policy.TIME_HARD);
            }
        } else if (existingDecl.getExpirationPolicy() == Expires.Policy.TIME_SOFT && newDecl.getExpirationOffset() > existingDecl.getExpirationOffset()) {
            existingDecl.setExpirationOffset(newDecl.getExpirationOffset());
        }
        if (newDecl.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && newDecl.isNovel()) {
            existingDecl.setNovel(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @novel attribute for type declaration of class:", existingDecl.isNovel(), newDecl.isNovel(), true, false));
        }
        if (newDecl.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) || existingDecl.getResource() == null) {
            existingDecl.setResource(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge resource attribute for type declaration of class:", existingDecl.getResource(), newDecl.getResource(), true, true));
        }
        existingDecl.setRole(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @role attribute for type declaration of class:", BitMaskUtil.isSet(existingDecl.getSetMask(), 1L) && newDecl.getRole() != Role.Type.FACT ? existingDecl.getRole() : null, newDecl.getRole(), true, false));
        existingDecl.setTimestampAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @timestamp attribute for type declaration of class:", existingDecl.getTimestampAttribute(), newDecl.getTimestampAttribute(), true, false));
        existingDecl.setTypesafe(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @typesafe attribute for type declaration of class:", existingDecl.isTypesafe(), newDecl.isTypesafe(), true, false));
    }

    private <T> T mergeLeft(String typeClass, String errorMsg, T leftVal, T rightVal, boolean errorOnDiff, boolean override) {
        T newValue = leftVal;
        if (!ClassUtils.areNullSafeEquals(leftVal, rightVal)) {
            if (leftVal == null) {
                newValue = rightVal;
            } else if (rightVal != null) {
                if (override) {
                    newValue = rightVal;
                } else if (errorOnDiff) {
                    throw new RuntimeException(errorMsg + " '" + typeClass + "'");
                }
            }
        }
        return newValue;
    }

    private void mergePackage(InternalKnowledgePackage pkg, InternalKnowledgePackage newPkg) {
        Map<String, ImportDeclaration> imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        for (String string : newPkg.getStaticImports()) {
            pkg.addStaticImport(string);
        }
        if (newPkg.getGlobals() != null && !newPkg.getGlobals().isEmpty()) {
            Iterator<KnowledgeDefinition> pkgGlobals = pkg.getGlobals();
            for (Map.Entry<String, Class<?>> entry : newPkg.getGlobals().entrySet()) {
                String identifier = entry.getKey();
                Class<?> type = entry.getValue();
                if (pkgGlobals.containsKey(identifier) && !((Class)pkgGlobals.get(identifier)).equals(type)) {
                    throw new RuntimeException(pkg.getName() + " cannot be integrated");
                }
                pkg.addGlobal(identifier, type);
                this.addGlobal(identifier, type);
            }
        }
        if (newPkg.getEntryPointIds() != null) {
            for (String string : newPkg.getEntryPointIds()) {
                pkg.addEntryPointId(string);
            }
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration typeDeclaration : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(typeDeclaration.getTypeName())) continue;
                pkg.addTypeDeclaration(typeDeclaration);
            }
        }
        if (newPkg.getWindowDeclarations() != null) {
            for (WindowDeclaration windowDeclaration : newPkg.getWindowDeclarations().values()) {
                if (!pkg.getWindowDeclarations().containsKey(windowDeclaration.getName()) || pkg.getWindowDeclarations().get(windowDeclaration.getName()).equals(windowDeclaration)) {
                    pkg.addWindowDeclaration(windowDeclaration);
                    continue;
                }
                throw new RuntimeException("Unable to merge two conflicting window declarations for window named: " + windowDeclaration.getName());
            }
        }
        ArrayList<RuleImpl> rulesToBeRemoved = new ArrayList<RuleImpl>();
        for (Rule rule : newPkg.getRules()) {
            RuleImpl oldRule = pkg.getRule(rule.getName());
            if (oldRule == null) continue;
            rulesToBeRemoved.add(oldRule);
        }
        if (!rulesToBeRemoved.isEmpty()) {
            this.removeRules(rulesToBeRemoved);
        }
        for (Rule rule : newPkg.getRules()) {
            pkg.addRule((RuleImpl)rule);
        }
        if (newPkg.getRuleFlows() != null) {
            for (Process process : newPkg.getRuleFlows().values()) {
                pkg.addProcess(process);
            }
        }
        if (!newPkg.getResourceTypePackages().isEmpty()) {
            KieWeavers kieWeavers = (KieWeavers)ServiceRegistry.getInstance().get(KieWeavers.class);
            for (ResourceTypePackage<?> rtkKpg : newPkg.getResourceTypePackages().values()) {
                kieWeavers.merge((KieBase)this, (KiePackage)pkg, rtkKpg);
            }
        }
    }

    @Override
    public void addGlobal(String identifier, Class clazz) {
        this.globals.put(identifier, clazz);
    }

    @Override
    public void removeGlobal(String identifier) {
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            if (pkg.getGlobals().get(identifier) == null) continue;
            return;
        }
        this.globals.remove(identifier);
        for (InternalWorkingMemory wm : this.getWorkingMemories()) {
            wm.removeGlobal(identifier);
        }
    }

    protected void setupRete() {
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
        NodeFactory nodeFactory = this.kieComponentFactory.getNodeFactoryService();
        EntryPointNode epn = nodeFactory.buildEntryPointNode(this.reteooBuilder.getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, this.getConfiguration().isMultithreadEvaluation(), this.rete, EntryPointId.DEFAULT);
        epn.attach();
        BuildContext context = new BuildContext(this);
        context.setCurrentEntryPoint(epn.getEntryPoint());
        context.setTupleMemoryEnabled(true);
        context.setObjectTypeNodeMemoryEnabled(true);
        context.setPartitionId(RuleBasePartitionId.MAIN_PARTITION);
        ObjectTypeNode otn = nodeFactory.buildObjectTypeNode(this.reteooBuilder.getIdGenerator().getNextId(), epn, ClassObjectType.InitialFact_ObjectType, context);
        otn.attach(context);
    }

    @Override
    public void registerAddedEntryNodeCache(EntryPointNode node) {
        if (this.addedEntryNodeCache == null) {
            this.addedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.addedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getAddedEntryNodeCache() {
        return this.addedEntryNodeCache;
    }

    @Override
    public void registeRremovedEntryNodeCache(EntryPointNode node) {
        if (this.removedEntryNodeCache == null) {
            this.removedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.removedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getRemovedEntryNodeCache() {
        return this.removedEntryNodeCache;
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    @Override
    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    @Override
    public int getNodeCount() {
        return this.reteooBuilder.getIdGenerator().getLastId() + 1;
    }

    @Override
    public int getMemoryCount(String topic) {
        return this.reteooBuilder.getIdGenerator().getLastId(topic) + 1;
    }

    public void registerSegmentPrototype(LeftTupleSource tupleSource, SegmentMemory smem) {
        this.segmentProtos.put(tupleSource.getId(), smem.asPrototype());
    }

    @Override
    public boolean hasSegmentPrototypes() {
        return !this.segmentProtos.isEmpty();
    }

    @Override
    public void invalidateSegmentPrototype(LeftTupleNode rootNode) {
        this.segmentProtos.remove(rootNode.getId());
    }

    @Override
    public SegmentMemory createSegmentFromPrototype(InternalWorkingMemory wm, LeftTupleSource tupleSource) {
        SegmentMemory.Prototype proto = this.segmentProtos.get(tupleSource.getId());
        if (proto == null) {
            return null;
        }
        return proto.newSegmentMemory(wm);
    }

    @Override
    public SegmentMemory.Prototype getSegmentPrototype(SegmentMemory segment) {
        return this.segmentProtos.get(segment.getRootNode().getId());
    }

    @Override
    public TypeDeclaration getExactTypeDeclaration(Class<?> clazz) {
        return this.classTypeDeclaration.get(clazz.getName());
    }

    @Override
    public TypeDeclaration getOrCreateExactTypeDeclaration(Class<?> clazz) {
        return this.classTypeDeclaration.computeIfAbsent(clazz.getName(), c -> TypeDeclaration.createTypeDeclarationForBean(clazz));
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        TypeDeclaration typeDeclaration = this.getExactTypeDeclaration(clazz);
        if (typeDeclaration == null) {
            TypeDeclarationCandidate candidate = this.checkSuperClasses(clazz);
            if ((candidate = this.checkInterfaces(clazz, candidate, 1)) != null) {
                typeDeclaration = candidate.candidate;
            }
        }
        return typeDeclaration;
    }

    private TypeDeclarationCandidate checkSuperClasses(Class<?> clazz) {
        TypeDeclaration typeDeclaration = null;
        int score = 0;
        for (Class<?> current = clazz.getSuperclass(); typeDeclaration == null && current != null; current = current.getSuperclass()) {
            ++score;
            typeDeclaration = this.classTypeDeclaration.get(current.getName());
        }
        TypeDeclarationCandidate candidate = null;
        if (typeDeclaration != null) {
            candidate = new TypeDeclarationCandidate();
            candidate.candidate = typeDeclaration;
            candidate.score = score;
        }
        return candidate;
    }

    private TypeDeclarationCandidate checkInterfaces(Class<?> clazz, TypeDeclarationCandidate baseline, int level) {
        TypeDeclarationCandidate candidate = null;
        if (baseline == null || level < baseline.score) {
            for (Class<?> ifc : clazz.getInterfaces()) {
                TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(ifc.getName());
                if (typeDeclaration != null) {
                    candidate = new TypeDeclarationCandidate();
                    candidate.candidate = typeDeclaration;
                    candidate.score = level;
                    break;
                }
                candidate = this.checkInterfaces(ifc, baseline, level + 1);
            }
        } else {
            candidate = baseline;
        }
        return candidate;
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.classTypeDeclaration.values();
    }

    @Override
    public void addRules(Collection<RuleImpl> rules) throws InvalidPatternException {
        this.enqueueModification(() -> {
            for (RuleImpl rule : rules) {
                this.internalAddRule(rule);
            }
        });
    }

    private void internalAddRule(RuleImpl rule) {
        this.eventSupport.fireBeforeRuleAdded(rule);
        this.reteooBuilder.addRule(rule);
        this.eventSupport.fireAfterRuleAdded(rule);
    }

    public void removeQuery(String packageName, String ruleName) {
        this.removeRule(packageName, ruleName);
    }

    public void removeRule(String packageName, String ruleName) {
        this.enqueueModification(() -> {
            InternalKnowledgePackage pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            RuleImpl rule = pkg.getRule(ruleName);
            if (rule == null) {
                throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
            }
            this.eventSupport.fireBeforeRuleRemoved(rule);
            this.reteooBuilder.removeRules(Collections.singletonList(rule));
            this.eventSupport.fireAfterRuleRemoved(rule);
            pkg.removeRule(rule);
            this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
        });
    }

    @Override
    public void removeRules(Collection<RuleImpl> rules) {
        this.enqueueModification(() -> this.internalRemoveRules(rules));
    }

    private void internalRemoveRules(Collection<RuleImpl> rules) {
        for (RuleImpl rule : rules) {
            this.eventSupport.fireBeforeRuleRemoved(rule);
        }
        this.reteooBuilder.removeRules(rules);
        for (RuleImpl rule : rules) {
            this.eventSupport.fireAfterRuleRemoved(rule);
        }
    }

    public void removeFunction(String packageName, String functionName) {
        this.enqueueModification(() -> this.internalRemoveFunction(packageName, functionName));
    }

    private void internalRemoveFunction(String packageName, String functionName) {
        InternalKnowledgePackage pkg = this.pkgs.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
        }
        Function function = pkg.getFunctions().get(functionName);
        if (function == null) {
            throw new IllegalArgumentException("function name '" + packageName + "' does not exist in the Package '" + packageName + "'.");
        }
        this.eventSupport.fireBeforeFunctionRemoved(pkg, functionName);
        pkg.removeFunction(functionName);
        this.eventSupport.fireAfterFunctionRemoved(pkg, functionName);
        if (this.rootClassLoader instanceof ProjectClassLoader) {
            ((ProjectClassLoader)this.rootClassLoader).undefineClass(function.getClassName());
        }
        this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
    }

    @Override
    public void addProcess(Process process) {
        this.lock();
        try {
            this.internalAddProcess(process);
        }
        finally {
            this.unlock();
        }
    }

    private void internalAddProcess(Process process) {
        this.eventSupport.fireBeforeProcessAdded(process);
        this.processes.put(process.getId(), process);
        this.eventSupport.fireAfterProcessAdded(process);
    }

    @Override
    public void removeProcess(String id) {
        this.enqueueModification(() -> this.internalRemoveProcess(id));
    }

    private void internalRemoveProcess(String id) {
        Process process = this.processes.get(id);
        if (process == null) {
            throw new IllegalArgumentException("Process '" + id + "' does not exist for this Rule Base.");
        }
        this.eventSupport.fireBeforeProcessRemoved(process);
        this.processes.remove(id);
        this.pkgs.get(process.getPackageName()).removeRuleFlow(id);
        this.eventSupport.fireAfterProcessRemoved(process);
    }

    public Process getProcess(String id) {
        this.readLock();
        try {
            Process process = this.processes.get(id);
            return process;
        }
        finally {
            this.readUnlock();
        }
    }

    public void addStatefulSession(StatefulKnowledgeSessionImpl wm) {
        this.statefulSessions.add(wm);
    }

    @Override
    public InternalKnowledgePackage getPackage(String name) {
        return this.pkgs.get(name);
    }

    @Override
    public Collection<InternalWorkingMemory> getWorkingMemories() {
        return Collections.unmodifiableSet(this.statefulSessions);
    }

    @Override
    public RuleBaseConfiguration getConfiguration() {
        if (this.config == null) {
            this.config = new RuleBaseConfiguration();
        }
        return this.config;
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public void executeQueuedActions() {
        DialectRuntimeRegistry registry;
        while ((registry = this.reloadPackageCompilationData.poll()) != null) {
            registry.onBeforeExecute();
        }
    }

    @Override
    public RuleBasePartitionId createNewPartitionId() {
        return RuleBasePartitionId.createPartition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactType getFactType(String packageName, String typeName) {
        String name = packageName + "." + typeName;
        this.readLock();
        try {
            for (InternalKnowledgePackage pkg : this.pkgs.values()) {
                FactType type = pkg.getFactType(name);
                if (type == null) continue;
                FactType factType = type;
                return factType;
            }
            Iterator<InternalKnowledgePackage> iterator = null;
            return iterator;
        }
        finally {
            this.readUnlock();
        }
    }

    private void addReloadDialectDatas(DialectRuntimeRegistry registry) {
        this.reloadPackageCompilationData.offer(registry);
    }

    @Override
    public ClassFieldAccessorCache getClassFieldAccessorCache() {
        return this.classFieldAccessorCache;
    }

    public Set<String> getEntryPointIds() {
        HashSet<String> entryPointIds = new HashSet<String>();
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            entryPointIds.addAll(pkg.getEntryPointIds());
        }
        return entryPointIds;
    }

    @Override
    public TripleStore getTripleStore() {
        return this.getConfiguration().getComponentFactory().getTripleStore();
    }

    @Override
    public TraitRegistry getTraitRegistry() {
        return this.getConfiguration().getComponentFactory().getTraitRegistry();
    }

    @Override
    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        boolean modified = false;
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            Object function2;
            List<RuleImpl> rulesToBeRemoved = pkg.getRulesGeneratedFromResource(resource);
            if (!rulesToBeRemoved.isEmpty()) {
                this.reteooBuilder.removeRules(rulesToBeRemoved);
                for (RuleImpl ruleImpl : rulesToBeRemoved) {
                    pkg.removeRule(ruleImpl);
                }
            }
            List<Function> functionsToBeRemoved = pkg.removeFunctionsGeneratedFromResource(resource);
            for (Object function2 : functionsToBeRemoved) {
                this.internalRemoveFunction(pkg.getName(), ((Function)function2).getName());
            }
            List<Process> list = pkg.removeProcessesGeneratedFromResource(resource);
            function2 = list.iterator();
            while (function2.hasNext()) {
                Process process = (Process)function2.next();
                this.processes.remove(process.getId());
            }
            List<TypeDeclaration> removedTypes = pkg.removeTypesGeneratedFromResource(resource);
            boolean resourceTypePackageSomethingRemoved = pkg.removeFromResourceTypePackageGeneratedFromResource(resource);
            modified |= !rulesToBeRemoved.isEmpty() || !functionsToBeRemoved.isEmpty() || !list.isEmpty() || !removedTypes.isEmpty() || resourceTypePackageSomethingRemoved;
        }
        return modified;
    }

    @Override
    public ReleaseId getResolvedReleaseId() {
        return this.resolvedReleaseId;
    }

    @Override
    public void setResolvedReleaseId(ReleaseId currentReleaseId) {
        this.resolvedReleaseId = currentReleaseId;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public void setKieContainer(InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }

    public InternalKieContainer getKieContainer() {
        return this.kieContainer;
    }

    @Override
    public RuleUnitDescriptionRegistry getRuleUnitDescriptionRegistry() {
        return this.ruleUnitDescriptionRegistry;
    }

    @Override
    public boolean hasUnits() {
        return this.ruleUnitDescriptionRegistry.hasUnits();
    }

    @Override
    public List<AsyncReceiveNode> getReceiveNodes() {
        return this.receiveNodes;
    }

    @Override
    public void addReceiveNode(AsyncReceiveNode node) {
        if (this.receiveNodes == null) {
            this.receiveNodes = new ArrayList<AsyncReceiveNode>();
        }
        this.receiveNodes.add(node);
    }

    private static class TypeDeclarationCandidate {
        public TypeDeclaration candidate = null;
        public int score = Integer.MAX_VALUE;

        private TypeDeclarationCandidate() {
        }
    }

    public static interface ClassRegister {
        public void register(String var1, byte[] var2) throws ClassNotFoundException;
    }
}

