/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.audit.event.RuleFlowLogEvent;

public class RuleFlowNodeLogEvent
extends RuleFlowLogEvent {
    private String nodeId;
    private String nodeName;
    private String nodeInstanceId;

    public RuleFlowNodeLogEvent(int type, String nodeId, String nodeName, String nodeInstanceId, String processId, String processName, long processInstanceId) {
        super(type, processId, processName, processInstanceId);
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.nodeInstanceId = nodeInstanceId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.nodeId = (String)in.readObject();
        this.nodeName = (String)in.readObject();
        this.nodeInstanceId = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.nodeId);
        out.writeObject(this.nodeName);
        out.writeObject(this.nodeInstanceId);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    @Override
    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 24: {
                msg = "BEFORE PROCESS NODE TRIGGERED";
                break;
            }
            case 25: {
                msg = "AFTER PROCESS NODE TRIGGERED";
                break;
            }
            case 26: {
                msg = "BEFORE PROCESS NODE EXITED";
                break;
            }
            case 27: {
                msg = "AFTER PROCESS NODE EXITED";
                break;
            }
            default: {
                return super.toString();
            }
        }
        return msg + " node:" + this.nodeName + "[id=" + this.nodeId + "] process:" + this.getProcessName() + "[id=" + this.getProcessId() + "]";
    }
}

