/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DeleteObjectCommand
implements ExecutableCommand<Void> {
    @XmlAttribute(name="object")
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Object object;
    @XmlAttribute(name="entry-point")
    private String entryPoint = "DEFAULT";

    public DeleteObjectCommand() {
    }

    public DeleteObjectCommand(Object object, String entryPoint) {
        this.object = object;
        if (!StringUtils.isEmpty(this.entryPoint)) {
            this.entryPoint = entryPoint;
        }
    }

    @Override
    public Void execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        EntryPoint ep = ksession.getEntryPoint(this.entryPoint);
        if (ep != null) {
            FactHandle handle = ksession.getEntryPoint(this.entryPoint).getFactHandle(this.object);
            ksession.delete(handle);
        }
        return null;
    }

    public Object getObject() {
        return this.object;
    }

    public String getEntryPointId() {
        return this.entryPoint;
    }

    public String toString() {
        return "session.entryPoints(" + (this.entryPoint == null ? "DEFAULT" : this.entryPoint) + ").delete( " + this.object + " );";
    }
}

