/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.drools.core.command.RequestContextImpl;
import org.drools.core.command.impl.ContextImpl;
import org.kie.api.runtime.Context;

public class ConversationContextManager {
    private Map<String, Context> conversationContexts = new HashMap<String, Context>();
    private long counter;

    public void startConversation(RequestContextImpl requestContext) {
        String conversationId = UUID.randomUUID().toString();
        ContextImpl ctx = new ContextImpl(conversationId, null);
        this.conversationContexts.put(conversationId, ctx);
        requestContext.setConversationContext(ctx);
    }

    public void joinConversation(RequestContextImpl requestContext, String conversationId) {
        Context ctx = this.conversationContexts.get(conversationId);
        if (ctx == null) {
            throw new RuntimeException("Conversation cannot be found");
        }
        requestContext.setConversationContext(ctx);
    }

    public void leaveConversation(RequestContextImpl requestContext, String conversationId) {
        throw new UnsupportedOperationException("Need to implement");
    }

    public void endConversation(RequestContextImpl requestContext, String conversationId) {
        this.conversationContexts.remove(conversationId);
        requestContext.setConversationContext(null);
    }
}

