/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class AverageAccumulateFunction
extends AbstractAccumulateFunction<AverageData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public AverageData createContext() {
        return new AverageData();
    }

    public void init(AverageData data) {
        data.count = 0;
        data.total = 0.0;
    }

    public void accumulate(AverageData data, Object value) {
        if (value != null) {
            ++data.count;
            data.total += ((Number)value).doubleValue();
        }
    }

    public void reverse(AverageData data, Object value) {
        if (value != null) {
            --data.count;
            data.total -= ((Number)value).doubleValue();
        }
    }

    public Object getResult(AverageData data) {
        return new Double(data.count == 0 ? 0.0 : data.total / (double)data.count);
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Double.class;
    }

    public static class AverageData
    implements Externalizable {
        public int count = 0;
        public double total = 0.0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readInt();
            this.total = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.count);
            out.writeDouble(this.total);
        }
    }
}

