/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.runtime.process;

import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.kie.internal.utils.ServiceRegistryImpl;

public class ProcessRuntimeFactory {
    private static final String PROVIDER_CLASS = "org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl";
    private static ProcessRuntimeFactoryService provider = ProcessRuntimeFactory.initializeProvider();

    private static ProcessRuntimeFactoryService initializeProvider() {
        ProcessRuntimeFactoryService service = null;
        try {
            ServiceRegistryImpl.getInstance().addDefault(ProcessRuntimeFactoryService.class, PROVIDER_CLASS);
            service = (ProcessRuntimeFactoryService)ServiceRegistryImpl.getInstance().get(ProcessRuntimeFactoryService.class);
            ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)ServiceRegistryImpl.getInstance().get(ProcessRuntimeFactoryService.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return service;
    }

    public static synchronized void reInitializeProvider() {
        provider = ProcessRuntimeFactory.initializeProvider();
    }

    public static InternalProcessRuntime newProcessRuntime(StatefulKnowledgeSessionImpl workingMemory) {
        return provider == null ? null : provider.newProcessRuntime(workingMemory);
    }

    public static void setProcessRuntimeFactoryService(ProcessRuntimeFactoryService provider) {
        ProcessRuntimeFactory.provider = provider;
    }

    public static ProcessRuntimeFactoryService getProcessRuntimeFactoryService() {
        return provider;
    }
}

