/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.ResourceProvider;
import org.drools.core.util.ClassUtils;

public class ProjectClassLoader
extends ClassLoader {
    private static final boolean CACHE_NON_EXISTING_CLASSES = true;
    private static final ClassNotFoundException dummyCFNE = new ClassNotFoundException("This is just a cached Exception. Disable non existing classes cache to see the actual one.");
    private static boolean isIBM_JVM = System.getProperty("java.vendor").toLowerCase().contains("ibm");
    private Map<String, byte[]> store;
    private Map<String, ClassBytecode> definedTypes;
    private final Set<String> nonExistingClasses = new HashSet<String>();
    private ClassLoader droolsClassLoader;
    private InternalTypesClassLoader typesClassLoader;
    private final Map<String, Class<?>> loadedClasses = new ConcurrentHashMap();
    private ResourceProvider resourceProvider;

    private ProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        super(parent);
        this.resourceProvider = resourceProvider;
    }

    private static ProjectClassLoader internalCreate(ClassLoader parent, ResourceProvider resourceProvider) {
        return isIBM_JVM ? new IBMClassLoader(parent, resourceProvider) : new ProjectClassLoader(parent, resourceProvider);
    }

    public static ClassLoader getClassLoader(ClassLoader classLoader, Class<?> cls, boolean enableCache) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(classLoader);
        if (cls != null) {
            projectClassLoader.setDroolsClassLoader(cls.getClassLoader());
        }
        return projectClassLoader;
    }

    public static ClassLoader findParentClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (parent == null) {
            parent = ProjectClassLoader.class.getClassLoader();
        }
        return parent;
    }

    public static ProjectClassLoader createProjectClassLoader() {
        return ProjectClassLoader.internalCreate(ProjectClassLoader.findParentClassLoader(), null);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent) {
        return ProjectClassLoader.createProjectClassLoader(parent, (ResourceProvider)null);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        if (parent == null) {
            return ProjectClassLoader.internalCreate(ProjectClassLoader.findParentClassLoader(), resourceProvider);
        }
        return parent instanceof ProjectClassLoader ? (ProjectClassLoader)parent : ProjectClassLoader.internalCreate(parent, resourceProvider);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, Map<String, byte[]> store) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(parent);
        projectClassLoader.store = store;
        return projectClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.loadedClasses.get(name);
        if (cls != null) {
            return cls;
        }
        ProjectClassLoader projectClassLoader = this;
        synchronized (projectClassLoader) {
            try {
                cls = this.internalLoadClass(name, resolve);
            }
            catch (ClassNotFoundException e2) {
                cls = this.loadType(name, resolve);
            }
        }
        this.loadedClasses.put(name, cls);
        return cls;
    }

    public Class<?> internalLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.nonExistingClasses.contains(name)) {
            throw dummyCFNE;
        }
        if (this.droolsClassLoader != null) {
            try {
                return Class.forName(name, resolve, this.droolsClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(name, resolve, this.getParent());
        }
    }

    private Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        if (this.typesClassLoader != null) {
            try {
                return this.typesClassLoader.loadType(name, resolve);
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        return this.tryDefineType(name, cnfe);
    }

    public Class<?> tryDefineType(String name, ClassNotFoundException cnfe) throws ClassNotFoundException {
        byte[] bytecode = this.getBytecode(ClassUtils.convertClassToResourcePath(name));
        if (bytecode == null) {
            this.nonExistingClasses.add(name);
            throw cnfe != null ? cnfe : new ClassNotFoundException(name);
        }
        return this.defineType(name, bytecode);
    }

    private Class<?> defineType(String name, byte[] bytecode) {
        if (this.definedTypes == null) {
            this.definedTypes = new HashMap<String, ClassBytecode>();
        } else {
            ClassBytecode existingClass = this.definedTypes.get(name);
            if (existingClass != null && Arrays.equals(bytecode, existingClass.bytes)) {
                return existingClass.clazz;
            }
        }
        if (this.typesClassLoader == null) {
            this.typesClassLoader = this.makeClassLoader();
        }
        Class<?> clazz = this.typesClassLoader.defineClass(name, bytecode);
        this.definedTypes.put(name, new ClassBytecode(clazz, bytecode));
        this.loadedClasses.put(name, clazz);
        return clazz;
    }

    public Class<?> defineClass(String name, byte[] bytecode) {
        return this.defineClass(name, ClassUtils.convertClassToResourcePath(name), bytecode);
    }

    public synchronized Class<?> defineClass(String name, String resourceName, byte[] bytecode) {
        this.storeClass(name, resourceName, bytecode);
        return this.defineType(name, bytecode);
    }

    public void undefineClass(String name) {
        String resourceName = ClassUtils.convertClassToResourcePath(name);
        if (this.store.remove(resourceName) != null) {
            this.nonExistingClasses.add(name);
            this.typesClassLoader = null;
        }
    }

    public void storeClass(String name, byte[] bytecode) {
        this.storeClass(name, ClassUtils.convertClassToResourcePath(name), bytecode);
    }

    public void storeClass(String name, String resourceName, byte[] bytecode) {
        if (this.store == null) {
            this.store = new HashMap<String, byte[]>();
        }
        this.store.put(resourceName, bytecode);
        this.nonExistingClasses.remove(name);
    }

    public boolean isClassInUse(String className) {
        return this.loadedClasses.containsKey(className);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytecode = this.getBytecode(name);
        if (bytecode != null) {
            return new ByteArrayInputStream(bytecode);
        }
        if (this.resourceProvider != null) {
            try {
                InputStream is = this.resourceProvider.getResourceAsStream(name);
                if (is != null) {
                    return is;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource;
        if (this.droolsClassLoader != null && (resource = this.droolsClassLoader.getResource(name)) != null) {
            return resource;
        }
        if (this.resourceProvider != null && (resource = this.resourceProvider.getResource(name)) != null) {
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = super.getResources(name);
        if (this.resourceProvider != null) {
            URL providedResource = this.resourceProvider.getResource(name);
            if (resources != null) {
                return new ResourcesEnum(providedResource, resources);
            }
        }
        return resources;
    }

    public byte[] getBytecode(String resourceName) {
        return this.store == null ? null : this.store.get(resourceName);
    }

    public Map<String, byte[]> getStore() {
        return this.store;
    }

    public void setDroolsClassLoader(ClassLoader droolsClassLoader) {
        if (this.getParent() != droolsClassLoader) {
            this.droolsClassLoader = droolsClassLoader;
            this.nonExistingClasses.clear();
        }
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public void initFrom(ProjectClassLoader other) {
        if (other.store != null) {
            if (this.store == null) {
                this.store = new HashMap<String, byte[]>();
            }
            this.store.putAll(other.store);
        }
        this.nonExistingClasses.addAll(other.nonExistingClasses);
    }

    private InternalTypesClassLoader makeClassLoader() {
        return ClassUtils.isAndroid() ? (InternalTypesClassLoader)ClassUtils.instantiateObject("org.drools.android.DexInternalTypesClassLoader", null, this) : new DefaultInternalTypesClassLoader(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectClassLoader)) {
            return false;
        }
        ProjectClassLoader that = (ProjectClassLoader)o;
        if (this.droolsClassLoader != null ? !this.droolsClassLoader.equals(that.droolsClassLoader) : that.droolsClassLoader != null) {
            return false;
        }
        if (this.typesClassLoader != null ? !this.typesClassLoader.equals(that.typesClassLoader) : that.typesClassLoader != null) {
            return false;
        }
        if (this.getParent() != null ? !this.getParent().equals(that.getParent()) : that.getParent() != null) {
            return false;
        }
        return this.resourceProvider != null ? this.resourceProvider.equals(that.resourceProvider) : that.resourceProvider == null;
    }

    public int hashCode() {
        int result = this.droolsClassLoader != null ? this.droolsClassLoader.hashCode() : 0;
        result = 31 * result + (this.typesClassLoader != null ? this.typesClassLoader.hashCode() : 0);
        result = 31 * result + (this.resourceProvider != null ? this.resourceProvider.hashCode() : 0);
        result = 31 * result + (this.getParent() != null ? this.getParent().hashCode() : 0);
        return result;
    }

    public synchronized void reinitTypes() {
        this.typesClassLoader = null;
        this.nonExistingClasses.clear();
        this.loadedClasses.clear();
    }

    private static class ClassBytecode {
        private final Class<?> clazz;
        private final byte[] bytes;

        private ClassBytecode(Class<?> clazz, byte[] bytes) {
            this.clazz = clazz;
            this.bytes = bytes;
        }
    }

    private static class DefaultInternalTypesClassLoader
    extends ClassLoader
    implements InternalTypesClassLoader {
        private final ProjectClassLoader projectClassLoader;

        private DefaultInternalTypesClassLoader(ProjectClassLoader projectClassLoader) {
            super(projectClassLoader.getParent());
            this.projectClassLoader = projectClassLoader;
        }

        @Override
        public Class<?> defineClass(String name, byte[] bytecode) {
            String pkgName;
            int lastDot = name.lastIndexOf(46);
            if (lastDot > 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, "", "", "", "", "", "", null);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return this.loadType(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                ProjectClassLoader projectClassLoader = this.projectClassLoader;
                synchronized (projectClassLoader) {
                    try {
                        return this.projectClassLoader.internalLoadClass(name, resolve);
                    }
                    catch (ClassNotFoundException cnfe2) {
                        return this.projectClassLoader.tryDefineType(name, cnfe);
                    }
                }
            }
        }

        @Override
        public Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        @Override
        public URL getResource(String name) {
            return this.projectClassLoader.getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.projectClassLoader.getResourceAsStream(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.projectClassLoader.getResources(name);
        }
    }

    static interface InternalTypesClassLoader {
        public Class<?> defineClass(String var1, byte[] var2);

        public Class<?> loadType(String var1, boolean var2) throws ClassNotFoundException;
    }

    private static class ResourcesEnum
    implements Enumeration<URL> {
        private URL providedResource;
        private final Enumeration<URL> resources;

        private ResourcesEnum(URL providedResource, Enumeration<URL> resources) {
            this.providedResource = providedResource;
            this.resources = resources;
        }

        @Override
        public boolean hasMoreElements() {
            return this.providedResource != null || this.resources.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            if (this.providedResource != null) {
                URL result = this.providedResource;
                this.providedResource = null;
                return result;
            }
            return this.resources.nextElement();
        }
    }

    public static class IBMClassLoader
    extends ProjectClassLoader {
        private final boolean parentImplementsFindResources;
        private static final Enumeration<URL> EMPTY_RESOURCE_ENUM = new Vector().elements();

        private IBMClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
            super(parent, resourceProvider);
            Method m = null;
            try {
                m = parent.getClass().getMethod("findResources", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.parentImplementsFindResources = m != null && m.getDeclaringClass() == parent.getClass();
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.parentImplementsFindResources ? EMPTY_RESOURCE_ENUM : this.getParent().getResources(name);
        }
    }
}

