/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.assertion;

import java.util.HashMap;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;

public class AssertEquals
implements ExecutableCommand<Void> {
    private String message;
    private Object expectedObject;
    private String expectedIdentifier;
    private Command command;
    private String mvelString;

    public AssertEquals(String message, Object expectedObject, Command command, String mvelString) {
        this.message = message;
        this.expectedObject = expectedObject;
        this.command = command;
        this.mvelString = mvelString;
    }

    public AssertEquals(String message, String expectedIdentifier, Command command, String mvelString) {
        this.message = message;
        this.expectedIdentifier = expectedIdentifier;
        this.command = command;
        this.mvelString = mvelString;
    }

    @Override
    public Void execute(Context context) {
        Object actualObject = ((ExecutableCommand)this.command).execute(context);
        if (this.mvelString != null) {
            actualObject = MVELSafeHelper.getEvaluator().eval(this.mvelString, actualObject);
        }
        if (this.expectedIdentifier != null) {
            this.expectedObject = context.get(this.expectedIdentifier);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("expected", this.expectedObject);
        vars.put("actual", actualObject);
        if (((Boolean)MVELSafeHelper.getEvaluator().eval("expected != actual", vars)).booleanValue()) {
            throw new AssertionError((Object)AssertEquals.format(this.message, this.expectedObject, actualObject));
        }
        return null;
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isEmpty(message)) {
            builder.append(message);
            builder.append(" ");
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            builder.append("expected: ");
            builder.append(AssertEquals.formatClassAndValue(expected, expectedString));
            builder.append(" but was: ");
            builder.append(AssertEquals.formatClassAndValue(actual, actualString));
        } else {
            builder.append("expected:<");
            builder.append(expectedString);
            builder.append("> but was:<");
            builder.append(actualString);
        }
        return builder.toString();
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    public String toString() {
        return "assert";
    }
}

