/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalAgenda;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.spi.Salience;

public class PhreakBranchNode {
    public void doNode(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(sink, agenda, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(branchNode, cbm, sink, agenda, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(branchNode, cbm, sink, agenda, srcLeftTuples, trgLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        int salienceInt = 0;
        Salience salience = ruleAgendaItem.getRule().getSalience();
        if (!salience.isDynamic()) {
            salienceInt = ruleAgendaItem.getRule().getSalience().getValue();
            salience = null;
        }
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            boolean breaking = false;
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, agenda.getWorkingMemory(), cbm.context);
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(branchNode, leftTuple);
            if (conditionalExecution != null) {
                RuleTerminalNode rtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                LeftTuple branchedLeftTuple = rtn.createLeftTuple(leftTuple, rtn, leftTuple.getPropagationContext(), useLeftMemory);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, executor, agenda, executor.getRuleAgendaItem(), salienceInt, salience, branchedLeftTuple);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        int salienceInt = 0;
        Salience salience = ruleAgendaItem.getRule().getSalience();
        if (!salience.isDynamic()) {
            salienceInt = ruleAgendaItem.getRule().getSalience().getValue();
            salience = null;
        }
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            BranchTuples branchTuples = this.getBranchTuples(sink, leftTuple);
            RuleTerminalNode oldRtn = null;
            if (branchTuples.rtnLeftTuple != null) {
                oldRtn = (RuleTerminalNode)branchTuples.rtnLeftTuple.getTupleSink();
            }
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, agenda.getWorkingMemory(), cbm.context);
            RuleTerminalNode newRtn = null;
            boolean breaking = false;
            if (conditionalExecution != null) {
                newRtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                breaking = conditionalExecution.isBreaking();
            }
            if (oldRtn != null) {
                if (newRtn == null) {
                    if (branchTuples.rtnLeftTuple.getMemory() != null) {
                        executor.removeLeftTuple(branchTuples.rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(agenda, executor, branchTuples.rtnLeftTuple);
                } else if (newRtn == oldRtn) {
                    PhreakRuleTerminalNode.doLeftTupleUpdate(newRtn, executor, agenda, salienceInt, salience, branchTuples.rtnLeftTuple);
                } else {
                    if (branchTuples.rtnLeftTuple.getMemory() != null) {
                        executor.removeLeftTuple(branchTuples.rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(agenda, executor, branchTuples.rtnLeftTuple);
                    branchTuples.rtnLeftTuple = newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                    PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, agenda, executor.getRuleAgendaItem(), salienceInt, salience, branchTuples.rtnLeftTuple);
                }
            } else if (newRtn != null) {
                branchTuples.rtnLeftTuple = newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, agenda, executor.getRuleAgendaItem(), salienceInt, salience, branchTuples.rtnLeftTuple);
            }
            if (branchTuples.mainLeftTuple != null) {
                RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, branchTuples.mainLeftTuple);
                if (!breaking) {
                    trgLeftTuples.addUpdate(branchTuples.mainLeftTuple);
                } else {
                    trgLeftTuples.addDelete(branchTuples.mainLeftTuple);
                }
            } else if (!breaking) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, RuleExecutor executor) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            BranchTuples branchTuples = this.getBranchTuples(sink, leftTuple);
            if (branchTuples.rtnLeftTuple != null) {
                if (branchTuples.rtnLeftTuple.getMemory() != null) {
                    executor.removeLeftTuple(branchTuples.rtnLeftTuple);
                }
                PhreakRuleTerminalNode.doLeftDelete(agenda, executor, branchTuples.rtnLeftTuple);
            }
            if (branchTuples.mainLeftTuple != null) {
                RuleNetworkEvaluator.deleteChildLeftTuple(branchTuples.mainLeftTuple, trgLeftTuples, stagedLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private BranchTuples getBranchTuples(LeftTupleSink sink, LeftTuple leftTuple) {
        BranchTuples branchTuples = new BranchTuples();
        LeftTuple child = leftTuple.getFirstChild();
        if (child != null) {
            if (child.getTupleSink() == sink) {
                branchTuples.mainLeftTuple = child;
            } else {
                branchTuples.rtnLeftTuple = child;
            }
            child = (LeftTuple)child.getHandleNext();
            if (child != null) {
                if (child.getTupleSink() == sink) {
                    branchTuples.mainLeftTuple = child;
                } else {
                    branchTuples.rtnLeftTuple = child;
                }
            }
        }
        return branchTuples;
    }

    private static class BranchTuples {
        LeftTuple rtnLeftTuple;
        LeftTuple mainLeftTuple;

        private BranchTuples() {
        }
    }
}

