/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.builder;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.runtime.Context;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class NewKnowledgeBuilderCommand
implements ExecutableCommand<KnowledgeBuilder> {
    private KnowledgeBuilderConfiguration kbuilderConf;
    private KnowledgeBase attachedKnowledgeBase;
    private String kbaseId;
    private String outIdentifier;

    public NewKnowledgeBuilderCommand() {
    }

    public NewKnowledgeBuilderCommand(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public NewKnowledgeBuilderCommand(KnowledgeBuilderConfiguration kbuilderConf) {
        this.kbuilderConf = kbuilderConf;
    }

    public NewKnowledgeBuilderCommand(KnowledgeBuilderConfiguration kbuilderConf, String kbaseId) {
        this.kbuilderConf = kbuilderConf;
        this.setAttachedKnowledgeBase(kbaseId);
    }

    public NewKnowledgeBuilderCommand(KnowledgeBuilderConfiguration kbuilderConf, String kbaseId, String outIdentifier) {
        this.kbuilderConf = kbuilderConf;
        this.setAttachedKnowledgeBase(kbaseId);
        this.outIdentifier = outIdentifier;
    }

    public KnowledgeBase getAttachedKnowledgeBase() {
        return this.attachedKnowledgeBase;
    }

    public void setAttachedKnowledgeBase(KnowledgeBase attachedKnowledgeBase) {
        this.attachedKnowledgeBase = attachedKnowledgeBase;
    }

    public void setAttachedKnowledgeBase(String kbaseId) {
        this.kbaseId = kbaseId;
    }

    @Override
    public KnowledgeBuilder execute(Context context) {
        KnowledgeBuilder kbuilder = null;
        if (!StringUtils.isEmpty(this.kbaseId)) {
            this.attachedKnowledgeBase = (KnowledgeBase)context.get(this.kbaseId);
        }
        kbuilder = this.kbuilderConf == null ? KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)this.attachedKnowledgeBase) : KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)this.attachedKnowledgeBase, (KnowledgeBuilderConfiguration)this.kbuilderConf);
        if (context instanceof RegistryContext) {
            ((RegistryContext)context).register(KnowledgeBuilder.class, kbuilder);
        }
        if (this.outIdentifier != null) {
            ((RegistryContext)context).lookup(ExecutionResultImpl.class).setResult(this.outIdentifier, kbuilder);
        }
        return kbuilder;
    }
}

