/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.TupleList;

public class TupleIndexHashTable
extends AbstractHashTable
implements TupleMemory {
    private static final long serialVersionUID = 510L;
    public static final int PRIME = 31;
    private int startResult;
    private transient FieldIndexHashTableFullIterator tupleValueFullIterator;
    private transient FullFastIterator fullFastIterator;
    private int factSize;
    private AbstractHashTable.Index index;
    private boolean left;

    public TupleIndexHashTable() {
    }

    public TupleIndexHashTable(AbstractHashTable.FieldIndex[] index, boolean left) {
        this(128, 0.75f, index, left);
    }

    public TupleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.FieldIndex[] index, boolean left) {
        super(capacity, loadFactor);
        this.left = left;
        this.startResult = 31;
        for (AbstractHashTable.FieldIndex i : index) {
            this.startResult += 31 * this.startResult + i.getExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startResult = in.readInt();
        this.factSize = in.readInt();
        this.index = (AbstractHashTable.Index)in.readObject();
        this.left = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startResult);
        out.writeInt(this.factSize);
        out.writeObject(this.index);
        out.writeBoolean(this.left);
    }

    public void init(Entry[] table, int size, int factSize) {
        this.table = table;
        this.size = size;
        this.factSize = factSize;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        } else {
            this.tupleValueFullIterator.reset();
        }
        return this.tupleValueFullIterator;
    }

    @Override
    public FastIterator fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator fullFastIterator() {
        if (this.fullFastIterator == null) {
            this.fullFastIterator = new FullFastIterator(this.table);
        } else {
            this.fullFastIterator.reset(this.table);
        }
        return this.fullFastIterator;
    }

    @Override
    public FastIterator fullFastIterator(Tuple leftTuple) {
        this.fullFastIterator.resume(leftTuple.getMemory(), this.table);
        return this.fullFastIterator;
    }

    @Override
    public Tuple getFirst(Tuple rightTuple) {
        TupleList bucket = this.get(rightTuple, !this.left);
        return bucket != null ? bucket.getFirst() : null;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    @Override
    public int getResizeHashcode(Entry entry) {
        return entry.hashCode();
    }

    public Tuple[] toArray() {
        Tuple[] result = new Tuple[this.factSize];
        int index = 0;
        for (Entry aTable : this.table) {
            for (TupleList bucket = (TupleList)aTable; bucket != null; bucket = bucket.getNext()) {
                for (Tuple entry = bucket.getFirst(); entry != null; entry = (Tuple)entry.getNext()) {
                    result[index++] = entry;
                }
            }
        }
        return result;
    }

    @Override
    public void removeAdd(Tuple tuple) {
        TupleList memory = tuple.getMemory();
        memory.remove(tuple);
        int newHashCode = this.index.hashCodeOf(tuple, this.left);
        if (newHashCode == memory.hashCode()) {
            memory.add(tuple);
            return;
        }
        --this.factSize;
        if (memory.getFirst() == null) {
            TupleList current;
            int index = TupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            TupleList previous = null;
            for (current = (TupleList)this.table[index]; current != memory; current = current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.setNext(current.getNext());
            } else {
                this.table[index] = current.getNext();
            }
            --this.size;
        }
        this.add(tuple);
    }

    @Override
    public void add(Tuple tuple) {
        TupleList entry = this.getOrCreate(tuple);
        entry.add(tuple);
        ++this.factSize;
    }

    @Override
    public void remove(Tuple tuple) {
        TupleList memory = tuple.getMemory();
        memory.remove(tuple);
        --this.factSize;
        if (memory.getFirst() == null) {
            TupleList current;
            int index = TupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            TupleList previous = null;
            for (current = (TupleList)this.table[index]; current != memory; current = current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.setNext(current.getNext());
            } else {
                this.table[index] = current.getNext();
            }
            --this.size;
        }
        tuple.clear();
    }

    private TupleList getOrCreate(Tuple tuple) {
        TupleList entry;
        int hashCode = this.index.hashCodeOf(tuple, this.left);
        int index = TupleIndexHashTable.indexOf(hashCode, this.table.length);
        for (entry = (TupleList)this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matchesRight(entry, tuple, hashCode)) continue;
            return entry;
        }
        entry = new TupleList(this.index, hashCode);
        entry.setNext((TupleList)this.table[index]);
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return entry;
    }

    @Override
    public boolean contains(Tuple tuple) {
        return this.get(tuple, this.left) != null;
    }

    private TupleList get(Tuple tuple, boolean isLeftTuple) {
        int hashCode = this.index.hashCodeOf(tuple, isLeftTuple);
        int index = TupleIndexHashTable.indexOf(hashCode, this.table.length);
        for (TupleList entry = (TupleList)this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matches(entry, tuple, hashCode)) continue;
            return entry;
        }
        return null;
    }

    private boolean matches(TupleList list, Tuple tuple, int tupleHashCode) {
        if (list.hashCode() != tupleHashCode) {
            return false;
        }
        return this.left ? this.index.equal(tuple.getFactHandle().getObject(), list.getFirst()) : this.index.equal(list.getFirst().getFactHandle().getObject(), tuple);
    }

    private boolean matchesRight(TupleList list, Tuple tuple, int tupleHashCode) {
        if (list.hashCode() != tupleHashCode) {
            return false;
        }
        return this.left ? this.index.equal(list.getFirst(), tuple) : this.index.equal(list.getFirst().getFactHandle().getObject(), tuple.getFactHandle().getObject());
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Tuple> it = this.iterator();
        Tuple leftTuple = it.next();
        while (leftTuple != null) {
            builder.append(leftTuple).append("\n");
            leftTuple = it.next();
        }
        return builder.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.startResult = 31;
        this.factSize = 0;
        this.fullFastIterator = null;
        this.tupleValueFullIterator = null;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.EQUAL;
    }

    public Tuple getFirst(Tuple leftTuple, InternalFactHandle factHandle) {
        TupleList bucket = this.get(leftTuple, factHandle);
        return bucket != null ? bucket.getFirst() : null;
    }

    private TupleList get(Tuple tuple, InternalFactHandle factHandle) {
        TupleList entry;
        int hashCode = this.index.hashCodeOf(tuple, !this.left);
        int index = TupleIndexHashTable.indexOf(hashCode, this.table.length);
        for (entry = (TupleList)this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matches(entry, tuple, hashCode, factHandle)) continue;
            return entry;
        }
        return entry;
    }

    private boolean matches(TupleList tupleList, Tuple tuple, int tupleHashCode, InternalFactHandle factHandle) {
        Tuple rightTuple;
        if (tupleList.hashCode() != tupleHashCode) {
            return false;
        }
        if (tupleList.getFirst().getFactHandle() == factHandle && (rightTuple = (Tuple)tupleList.getFirst().getNext()) != null) {
            return this.index.equal(rightTuple.getFactHandle().getObject(), tuple);
        }
        return this.index.equal(tupleList.getFirst().getFactHandle().getObject(), tuple);
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator<Tuple> {
        private final AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private TupleList list;
        private Tuple tuple;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
            this.reset();
        }

        @Override
        public Tuple next() {
            while (this.row <= this.length) {
                while (this.list == null) {
                    if (this.row < this.length) {
                        this.list = (TupleList)this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (this.list == null) continue;
                    this.tuple = this.list.getFirst();
                    return this.tuple;
                }
                this.tuple = (Tuple)this.tuple.getNext();
                if (this.tuple != null) {
                    return this.tuple;
                }
                this.list = this.list.getNext();
                if (this.list == null) continue;
                this.tuple = this.list.getFirst();
                return this.tuple;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("FieldIndexHashTableFullIterator does not support remove().");
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = 0;
            this.list = null;
            this.tuple = null;
        }
    }

    public static class FullFastIterator
    implements FastIterator {
        private Entry[] table;
        private int row;

        public FullFastIterator(Entry[] table, int row) {
            this.table = table;
            this.row = row + 1;
        }

        public FullFastIterator(Entry[] table) {
            this.table = table;
            this.row = 0;
        }

        public void resume(Entry target, Entry[] table) {
            this.table = table;
            this.row = TupleIndexHashTable.indexOf(target.hashCode(), this.table.length);
            ++this.row;
        }

        @Override
        public Entry next(Entry object) {
            Tuple tuple = (Tuple)object;
            TupleList list = null;
            if (tuple != null) {
                list = tuple.getMemory();
            }
            int length = this.table.length;
            while (this.row <= length) {
                while (list == null) {
                    if (this.row < length) {
                        list = (TupleList)this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (list == null) continue;
                    tuple = list.getFirst();
                    return tuple;
                }
                if ((tuple = (Tuple)tuple.getNext()) != null) {
                    return tuple;
                }
                if ((list = list.getNext()) == null) continue;
                tuple = list.getFirst();
                return tuple;
            }
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }

        public void reset(Entry[] table) {
            this.table = table;
            this.row = 0;
        }
    }
}

